<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial']);

$visit_id = (int)($_GET['id'] ?? 0);
if ($visit_id <= 0) {
    redirect('/public/visits/index.php');
}

/* =======================
   LIBELLÉS TYPES
   ======================= */
$VISIT_LABELS = [
    'prospection'    => 'Visite de prospection',
    'technique'      => 'Visite technique',
    'levee_reserves' => 'Visite de levée de réserves',
    'exceptionnelle' => 'Visite exceptionnelle',
];

/* =======================
   VISITE
   ======================= */
$stmt = $pdo->prepare("
    SELECT
        v.*,
        c.fullname AS client_name,
        c.phone AS client_phone,
        p.name AS project_name,
        u.name AS commercial
    FROM visits v
    LEFT JOIN clients c ON c.id = v.client_id
    LEFT JOIN projects p ON p.id = v.project_id
    LEFT JOIN users u ON u.id = v.created_by
    WHERE v.id = ?
");
$stmt->execute([$visit_id]);
$visit = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$visit) {
    redirect('/public/visits/index.php');
}

$title  = "Visite | IMMOTECH";
$active = 'visits';

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="card">
<div class="card-header">
    <h3 class="card-title">
        <?= e($VISIT_LABELS[$visit['type']] ?? $visit['type']) ?>
    </h3>
</div>

<div class="card-body">
<div class="row">

<div class="col-md-6">
    <p><strong>Client :</strong> <?= e($visit['client_name'] ?? '-') ?></p>
    <p><strong>Téléphone :</strong> <?= e($visit['client_phone'] ?? '-') ?></p>
    <p><strong>Projet :</strong> <?= e($visit['project_name'] ?? '-') ?></p>
</div>

<div class="col-md-6">
    <p><strong>Date :</strong> <?= date('d/m/Y H:i', strtotime($visit['visit_date'])) ?></p>
    <p><strong>Statut :</strong>
        <span class="badge badge-<?= $visit['status'] === 'realisee' ? 'success' : 'warning' ?>">
            <?= ucfirst($visit['status']) ?>
        </span>
    </p>
    <p><strong>Commercial :</strong> <?= e($visit['commercial'] ?? '-') ?></p>
</div>

</div>

<?php if (!empty($visit['notes'])): ?>
<hr>
<p><strong>Notes :</strong><br><?= nl2br(e($visit['notes'])) ?></p>
<?php endif; ?>

</div>

<div class="card-footer">
    <a href="<?= e(base_url('/public/visits/index.php')) ?>" class="btn btn-secondary">
        Retour
    </a>
</div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
