<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial']);

$title  = "Visites | IMMOTECH";
$active = 'visits';
$subactive = 'visits_list';

/* =======================
   LIBELLÉS TYPES DE VISITES
   ======================= */
$VISIT_LABELS = [
    'prospection'    => 'Visite de prospection',
    'technique'      => 'Visite technique',
    'levee_reserves' => 'Visite de levée de réserves',
    'exceptionnelle' => 'Visite exceptionnelle',
];

/* =======================
   LISTE DES VISITES
   ======================= */
$stmt = $pdo->query("
    SELECT
        v.id,
        v.type,
        v.visit_date,
        v.status,
        c.fullname AS client_name,
        p.name AS project_name,
        u.name AS commercial
    FROM visits v
    LEFT JOIN clients c ON c.id = v.client_id
    LEFT JOIN projects p ON p.id = v.project_id
    LEFT JOIN users u ON u.id = v.created_by
    ORDER BY v.visit_date DESC
");

$visits = $stmt->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="d-flex justify-content-between mb-3">
    <h3>Gestion des visites</h3>
    <a href="<?= e(base_url('/public/visits/create.php')) ?>" class="btn btn-success">
        <i class="fas fa-plus"></i> Nouvelle visite
    </a>
</div>

<div class="card">
<div class="card-body table-responsive p-0">
<table class="table table-hover mb-0">
<thead>
<tr>
    <th>#</th>
    <th>Type</th>
    <th>Client</th>
    <th>Projet</th>
    <th>Date</th>
    <th>Statut</th>
    <th>Commercial</th>
    <th>Action</th>
</tr>
</thead>
<tbody>

<?php if (!$visits): ?>
<tr>
    <td colspan="8" class="text-center text-muted p-4">Aucune visite enregistrée</td>
</tr>
<?php else: foreach ($visits as $v): ?>
<tr>
    <td><?= (int)$v['id'] ?></td>
    <td><?= e($VISIT_LABELS[$v['type']] ?? $v['type']) ?></td>
    <td><?= e($v['client_name'] ?? '-') ?></td>
    <td><?= e($v['project_name'] ?? '-') ?></td>
    <td><?= date('d/m/Y H:i', strtotime($v['visit_date'])) ?></td>
    <td>
        <span class="badge badge-<?= $v['status'] === 'realisee' ? 'success' : 'warning' ?>">
            <?= ucfirst($v['status']) ?>
        </span>
    </td>
    <td><?= e($v['commercial'] ?? '-') ?></td>
    <td>
        <a href="<?= e(base_url('/public/visits/show.php?id='.$v['id'])) ?>"
           class="btn btn-sm btn-secondary">
            <i class="fas fa-eye"></i>
        </a>
    </td>
</tr>
<?php endforeach; endif; ?>

</tbody>
</table>
</div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
