<?php
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$visit_id = (int)($_GET['id'] ?? 0);
if ($visit_id <= 0) exit('ID invalide');

$pdo->beginTransaction();

try {
    // Récupérer contexte
    $stmt = $pdo->prepare("
        SELECT
            v.type,
            v.status AS visit_status,
            r.id AS reservation_id,
            r.lot_id,
            s.final_price,
            s.id AS simulation_id
        FROM visits v
        JOIN reservations r ON r.id = (
            SELECT id FROM reservations
            WHERE lot_id = v.lot_id
            ORDER BY id DESC LIMIT 1
        )
        JOIN simulations s ON s.id = r.simulation_id
        WHERE v.id = ?
    ");
    $stmt->execute([$visit_id]);
    $ctx = $stmt->fetch();

    if (!$ctx) throw new Exception('Contexte introuvable');

    if ($ctx['type'] !== 'pre_livraison') {
        throw new Exception('Cette visite n’est pas une pré-livraison');
    }

    if ($ctx['visit_status'] !== 'effectuee') {
        throw new Exception('La visite doit être effectuée');
    }

    // Vérifier paiement total
    $stmt = $pdo->prepare("
        SELECT IFNULL(SUM(pay.amount),0)
        FROM payment_orders po
        JOIN payments pay ON pay.payment_order_id = po.id
        WHERE po.simulation_id = ?
    ");
    $stmt->execute([$ctx['simulation_id']]);
    $paid = (float)$stmt->fetchColumn();

    if ($paid < (float)$ctx['final_price']) {
        throw new Exception('Paiement non soldé');
    }

    // Marquer réservation livrée
    $pdo->prepare("
        UPDATE reservations
        SET status = 'livree', delivered_at = NOW()
        WHERE id = ?
    ")->execute([$ctx['reservation_id']]);

    // Marquer lot livré
    $pdo->prepare("
        UPDATE lots
        SET status = 'livre'
        WHERE id = ?
    ")->execute([$ctx['lot_id']]);

    $pdo->commit();

    header("Location: show.php?id=$visit_id");

} catch (Exception $e) {
    $pdo->rollBack();
    die($e->getMessage());
}
