<?php
/******************** DEBUG ********************/
ini_set('display_errors', 1);
error_reporting(E_ALL);

/******************** INCLUDES ********************/
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial']);

$title     = "Planifier une visite";
$active    = 'visits';
$subactive = 'visits_create';

/* =====================
   UTILISATEUR CONNECTÉ
===================== */
$user = Auth::user(); // ✅ IMPORTANT
$created_by = $user['id'] ?? null;

if (!$created_by) {
    die("Utilisateur non identifié");
}

/* =====================
   DONNÉES
===================== */
$clients = $pdo->query("
    SELECT id, fullname, phone
    FROM clients
    ORDER BY fullname
")->fetchAll(PDO::FETCH_ASSOC);

$projects = $pdo->query("
    SELECT id, name
    FROM projects
    ORDER BY name
")->fetchAll(PDO::FETCH_ASSOC);

$lots = $pdo->query("
    SELECT 
        l.id,
        l.project_id,
        l.reference,
        lt.name AS lot_type
    FROM lots l
    JOIN lot_types lt ON lt.id = l.lot_type_id
    WHERE l.status IN ('disponible','reserve','vendu')
")->fetchAll(PDO::FETCH_ASSOC);

$errors = [];

/* =====================
   POST
===================== */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $client_id  = (int)($_POST['client_id'] ?? 0);
    $project_id = (int)($_POST['project_id'] ?? 0);
    $lot_id     = ($_POST['lot_id'] !== '' ? (int)$_POST['lot_id'] : null);
    $type       = $_POST['type'] ?? '';
    $visit_date = $_POST['visit_date'] ?? '';
    $notes      = trim($_POST['notes'] ?? '');

    /* VALIDATIONS */
    if ($client_id <= 0)  $errors[] = "Client obligatoire";
    if ($project_id <= 0) $errors[] = "Projet obligatoire";
    if ($type === '')     $errors[] = "Type de visite obligatoire";
    if ($visit_date === '') $errors[] = "Date de visite obligatoire";

    // Règles métier
    if (in_array($type, ['technique','levee_reserves']) && !$lot_id) {
        $errors[] = "Un lot est obligatoire pour ce type de visite";
    }

    if (!$errors) {

        $stmt = $pdo->prepare("
            INSERT INTO visits
            (
                client_id,
                project_id,
                lot_id,
                type,
                visit_date,
                notes,
                status,
                created_by
            )
            VALUES (?, ?, ?, ?, ?, ?, 'planifiee', ?)
        ");

        $stmt->execute([
            $client_id,
            $project_id,
            $lot_id,
            $type,
            $visit_date,
            $notes,
            $created_by
        ]);

        redirect('/public/visits/index.php');
        exit;
    }
}

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<script>
const ALL_LOTS = <?= json_encode($lots) ?>;
</script>

<section class="content pt-3">
<div class="container-fluid">

<div class="card">
  <div class="card-header">
    <h3 class="card-title">Planifier une visite</h3>
  </div>

  <div class="card-body">

<?php if ($errors): ?>
<div class="alert alert-danger">
  <ul class="mb-0">
    <?php foreach ($errors as $e): ?>
      <li><?= e($e) ?></li>
    <?php endforeach; ?>
  </ul>
</div>
<?php endif; ?>

<form method="post">

<div class="row">

  <div class="col-md-4">
    <label>Client *</label>
    <select name="client_id" class="form-control" required>
      <option value="">-- Choisir --</option>
      <?php foreach ($clients as $c): ?>
        <option value="<?= $c['id'] ?>">
          <?= e($c['fullname']) ?> (<?= e($c['phone']) ?>)
        </option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-4">
    <label>Projet *</label>
    <select name="project_id" id="project_id" class="form-control" required>
      <option value="">-- Choisir --</option>
      <?php foreach ($projects as $p): ?>
        <option value="<?= $p['id'] ?>"><?= e($p['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-4">
    <label>Type de visite *</label>
    <select name="type" id="type_visite" class="form-control" required>
      <option value="">-- Type de visite --</option>
      <option value="prospection">Visite de prospection</option>
      <option value="technique">Visite technique</option>
      <option value="levee_reserves">Visite de levée de réserves</option>
      <option value="exceptionnelle">Visite exceptionnelle</option>
    </select>
  </div>

</div>

<div class="row mt-3">

  <div class="col-md-4">
    <label>Lot concerné</label>
    <select name="lot_id" id="lot_id" class="form-control">
      <option value="">-- Aucun --</option>
    </select>
    <small class="text-muted">
      Obligatoire pour les visites techniques et levée de réserves
    </small>
  </div>

  <div class="col-md-4">
    <label>Date & heure *</label>
    <input type="datetime-local" name="visit_date" class="form-control" required>
  </div>

</div>

<div class="mt-3">
  <label>Notes</label>
  <textarea name="notes" class="form-control" rows="3"></textarea>
</div>

<div class="mt-4">
  <button class="btn btn-success">
    <i class="fas fa-save"></i> Enregistrer
  </button>
  <a href="<?= e(base_url('/public/visits/index.php')) ?>" class="btn btn-secondary ml-2">
    Annuler
  </a>
</div>

</form>

  </div>
</div>

</div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function () {

    const projectSelect = document.getElementById('project_id');
    const lotSelect     = document.getElementById('lot_id');
    const typeSelect    = document.getElementById('type_visite');

    function refreshLots() {
        const projectId = parseInt(projectSelect.value);
        lotSelect.innerHTML = '<option value="">-- Aucun --</option>';

        if (!projectId) return;

        ALL_LOTS
          .filter(l => l.project_id === projectId)
          .forEach(l => {
              const opt = document.createElement('option');
              opt.value = l.id;
              opt.textContent = `${l.lot_type} - ${l.reference}`;
              lotSelect.appendChild(opt);
          });
    }

    projectSelect.addEventListener('change', refreshLots);

    typeSelect.addEventListener('change', function () {
        if (['technique','levee_reserves'].includes(this.value)) {
            lotSelect.required = true;
        } else {
            lotSelect.required = false;
            lotSelect.value = '';
        }
    });

});
</script>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
