<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','finance']);

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) redirect('/public/suppliers/index.php');

$stmt = $pdo->prepare("SELECT * FROM suppliers WHERE id = ?");
$stmt->execute([$id]);
$supplier = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$supplier) redirect('/public/suppliers/index.php');

$title = "Fournisseur | " . $supplier['name'];
$active = 'purchases';
$subactive = 'suppliers';

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0"><?= e($supplier['name']) ?></h3>
  <a class="btn btn-secondary" href="<?= e(base_url('/public/suppliers/index.php')) ?>">
    <i class="fas fa-arrow-left"></i> Retour
  </a>
</div>

<div class="card">
  <div class="card-body">
    <p><strong>Téléphone :</strong> <?= e($supplier['phone'] ?? '-') ?></p>
    <p><strong>Email :</strong> <?= e($supplier['email'] ?? '-') ?></p>
    <p><strong>Adresse :</strong> <?= e($supplier['address'] ?? '-') ?></p>
    <p><strong>Note :</strong><br><?= nl2br(e($supplier['note'] ?? '-')) ?></p>
  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
