<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','finance']);

$title = "Fournisseurs | IMMOTECH";
$active = 'purchases';
$subactive = 'suppliers';

$q = trim($_GET['q'] ?? '');

$where = [];
$params = [];
if ($q !== '') {
    $where[] = "(s.name LIKE ? OR s.phone LIKE ? OR s.email LIKE ?)";
    $like = "%$q%";
    $params = [$like, $like, $like];
}

$sql = "
SELECT s.*
FROM suppliers s
" . ($where ? " WHERE " . implode(" AND ", $where) : "") . "
ORDER BY s.id DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$suppliers = $stmt->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Fournisseurs</h3>
  <?php if (Permissions::can(['admin','director','manager'])): ?>
    <a href="<?= e(base_url('/public/suppliers/create.php')) ?>" class="btn btn-success">
      <i class="fas fa-plus"></i> Ajouter
    </a>
  <?php endif; ?>
</div>

<div class="card mb-3">
  <div class="card-body">
    <form method="get" class="row">
      <div class="col-md-10">
        <input class="form-control" name="q" value="<?= e($q) ?>" placeholder="Recherche (nom, téléphone, email)">
      </div>
      <div class="col-md-2">
        <button class="btn btn-primary w-100"><i class="fas fa-search"></i></button>
      </div>
    </form>
  </div>
</div>

<div class="card">
  <div class="card-body table-responsive p-0">
    <table class="table table-hover mb-0">
      <thead>
        <tr>
          <th>#</th>
          <th>Nom</th>
          <th>Téléphone</th>
          <th>Email</th>
          <th>Adresse</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody>
      <?php if (!$suppliers): ?>
        <tr><td colspan="6" class="text-center text-muted p-4">Aucun fournisseur.</td></tr>
      <?php else: foreach ($suppliers as $s): ?>
        <tr>
          <td><?= (int)$s['id'] ?></td>
          <td><strong><?= e($s['name']) ?></strong></td>
          <td><?= e($s['phone'] ?? '-') ?></td>
          <td><?= e($s['email'] ?? '-') ?></td>
          <td><?= e($s['address'] ?? '-') ?></td>
          <td>
            <a href="<?= e(base_url('/public/suppliers/show.php?id='.(int)$s['id'])) ?>" class="btn btn-sm btn-secondary">
              <i class="fas fa-eye"></i>
            </a>
          </td>
        </tr>
      <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
