<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager']);

$title = "Ajouter fournisseur | IMMOTECH";
$active = 'purchases';
$subactive = 'suppliers';

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name    = trim($_POST['name'] ?? '');
    $phone   = trim($_POST['phone'] ?? '');
    $email   = trim($_POST['email'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $note    = trim($_POST['note'] ?? '');

    if ($name === '') $errors[] = "Nom obligatoire";

    if (!$errors) {
        $stmt = $pdo->prepare("
            INSERT INTO suppliers (name, phone, email, address, note)
            VALUES (?, ?, ?, ?, ?)
        ");
        $stmt->execute([
            $name,
            $phone ?: null,
            $email ?: null,
            $address ?: null,
            $note ?: null
        ]);

        redirect('/public/suppliers/index.php');
    }
}

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="card">
  <div class="card-header"><h3 class="card-title">Ajouter un fournisseur</h3></div>
  <div class="card-body">

    <?php if ($errors): ?>
      <div class="alert alert-danger"><ul class="mb-0">
        <?php foreach ($errors as $e): ?><li><?= e($e) ?></li><?php endforeach; ?>
      </ul></div>
    <?php endif; ?>

    <form method="post">
      <div class="form-group">
        <label>Nom *</label>
        <input name="name" class="form-control" required value="<?= e($_POST['name'] ?? '') ?>">
      </div>

      <div class="form-group">
        <label>Téléphone</label>
        <input name="phone" class="form-control" value="<?= e($_POST['phone'] ?? '') ?>">
      </div>

      <div class="form-group">
        <label>Email</label>
        <input name="email" type="email" class="form-control" value="<?= e($_POST['email'] ?? '') ?>">
      </div>

      <div class="form-group">
        <label>Adresse</label>
        <input name="address" class="form-control" value="<?= e($_POST['address'] ?? '') ?>">
      </div>

      <div class="form-group">
        <label>Note</label>
        <textarea name="note" class="form-control" rows="3"><?= e($_POST['note'] ?? '') ?></textarea>
      </div>

      <button class="btn btn-success"><i class="fas fa-save"></i> Enregistrer</button>
      <a class="btn btn-secondary" href="<?= e(base_url('/public/suppliers/index.php')) ?>">Annuler</a>
    </form>

  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
