<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','finance']);

$simulation_id = (int)($_GET['id'] ?? 0);

if ($simulation_id <= 0) {
    die("Simulation invalide");
}

/* =======================
   RÉCUPÉRATION SIMULATION
   ======================= */
$stmt = $pdo->prepare("
    SELECT s.*, l.project_id, l.price AS lot_price
    FROM simulations s
    JOIN lots l ON l.id = s.lot_id
    WHERE s.id = ?
");
$stmt->execute([$simulation_id]);
$simulation = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$simulation) {
    die("Simulation introuvable");
}

if ($simulation['status'] !== 'acceptee') {
    die("Cette simulation ne peut plus être validée");
}

/* =======================
   TRANSACTION
   ======================= */
$pdo->beginTransaction();

try {

    /* 1️⃣ Simulation → VALIDÉE */
    $pdo->prepare("
        UPDATE simulations
        SET status = 'validee'
        WHERE id = ?
    ")->execute([$simulation_id]);

    /* 2️⃣ Créer la réservation */
    $pdo->prepare("
        INSERT INTO reservations
        (client_id, lot_id, simulation_id, first_installment_amount, first_installment_percent, status, expires_at, created_by)
        VALUES (?, ?, ?, ?, ?, 'en_attente', DATE_ADD(NOW(), INTERVAL 7 DAY), ?)
    ")->execute([
        $simulation['client_id'],
        $simulation['lot_id'],
        $simulation_id,
        $simulation['final_price'] * ($simulation['paid_percent'] / 100),
        $simulation['paid_percent'],
        $_SESSION['user']['id']
    ]);

    /* 3️⃣ Générer l’OV */
    $pdo->prepare("
        INSERT INTO payment_orders
        (client_id, lot_id, reservation_id, amount, due_date, status, created_by)
        VALUES (?, ?, LAST_INSERT_ID(), ?, DATE_ADD(NOW(), INTERVAL 7 DAY), 'en_attente', ?)
    ")->execute([
        $simulation['client_id'],
        $simulation['lot_id'],
        $simulation['final_price'] * ($simulation['paid_percent'] / 100),
        $_SESSION['user']['id']
    ]);

    /* 4️⃣ Lot → réservé */
    $pdo->prepare("
        UPDATE lots
        SET status = 'reserve'
        WHERE id = ?
    ")->execute([$simulation['lot_id']]);

    $pdo->commit();

    redirect("/public/simulations/show.php?id=$simulation_id");

} catch (Throwable $e) {
    $pdo->rollBack();
    die("Erreur : " . $e->getMessage());
}
