<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

/******************** INCLUDES ********************/
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','finance']);

$simulation_id = (int)($_GET['id'] ?? 0);
if ($simulation_id <= 0) {
    die("Simulation invalide");
}

/* =======================
   SIMULATION + CLIENT + LOT
   ======================= */
$stmt = $pdo->prepare("
    SELECT
        s.*,
        c.fullname AS client_name,
        c.phone AS client_phone,
        l.reference AS lot_reference,
        l.price AS lot_price
    FROM simulations s
    JOIN clients c ON c.id = s.client_id
    JOIN lots l ON l.id = s.lot_id
    WHERE s.id = ?
");
$stmt->execute([$simulation_id]);
$simulation = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$simulation) {
    die("Simulation introuvable");
}

/* =======================
   RÉSERVATION (SI EXISTE)
   ======================= */
$stmt = $pdo->prepare("
    SELECT *
    FROM reservations
    WHERE simulation_id = ?
");
$stmt->execute([$simulation_id]);
$reservation = $stmt->fetch(PDO::FETCH_ASSOC);

/* =======================
   ORDRE DE VERSEMENT (OV)
   ======================= */
$stmt = $pdo->prepare("
    SELECT *
    FROM payment_orders
    WHERE simulation_id = ?
");
$stmt->execute([$simulation_id]);
$ov = $stmt->fetch(PDO::FETCH_ASSOC);

$title  = "Simulation #".$simulation['id'];
$active = 'simulations';

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<!-- =======================
     INFOS SIMULATION
     ======================= -->
<div class="card mb-3">
  <div class="card-header">
    <h3 class="card-title">
      <i class="fas fa-calculator"></i> Simulation #<?= (int)$simulation['id'] ?>
    </h3>
  </div>

  <div class="card-body">
    <div class="row">

      <div class="col-md-6">
        <p><strong>Client :</strong> <?= e($simulation['client_name']) ?></p>
        <p><strong>Téléphone :</strong> <?= e($simulation['client_phone'] ?? '-') ?></p>
        <p><strong>Lot :</strong> <?= e($simulation['lot_reference']) ?></p>
        <p><strong>Prix du lot :</strong> <?= number_format($simulation['lot_price'], 0, ' ', ' ') ?> DA</p>
      </div>

      <div class="col-md-6">
        <p><strong>% à payer :</strong> <?= number_format($simulation['paid_percent'], 2) ?> %</p>
        <p><strong>Remise :</strong> <?= number_format($simulation['discount_percent'], 2) ?> %</p>
        <p><strong>Prix final :</strong> <?= number_format($simulation['final_price'], 0, ' ', ' ') ?> DA</p>
        <p>
          <strong>Statut :</strong>
          <?php if ($simulation['status'] === 'en_attente'): ?>
            <span class="badge badge-secondary">En attente</span>
          <?php elseif ($simulation['status'] === 'acceptee'): ?>
            <span class="badge badge-success">Acceptée</span>
          <?php else: ?>
            <span class="badge badge-primary">Validée</span>
          <?php endif; ?>
        </p>
        <p><strong>Date :</strong> <?= e($simulation['created_at']) ?></p>
      </div>

    </div>
  </div>
</div>

<!-- =======================
     RÉSERVATION
     ======================= -->
<div class="card mb-3">
  <div class="card-header">
    <h4 class="card-title">
      <i class="fas fa-bookmark"></i> Réservation
    </h4>
  </div>

  <div class="card-body">
    <?php if (!$reservation): ?>
      <p class="text-muted mb-0">Aucune réservation liée à cette simulation.</p>
    <?php else: ?>
      <p><strong>ID réservation :</strong> <?= (int)$reservation['id'] ?></p>
      <p><strong>Statut :</strong> <?= e($reservation['status']) ?></p>
      <p><strong>Date réservation :</strong> <?= e($reservation['reserved_at']) ?></p>
      <p><strong>Expiration :</strong> <?= e($reservation['expires_at']) ?></p>
    <?php endif; ?>
  </div>
</div>

<!-- =======================
     ORDRE DE VERSEMENT
     ======================= -->
<div class="card mb-3">
  <div class="card-header">
    <h4 class="card-title">
      <i class="fas fa-file-invoice-dollar"></i> Ordre de versement
    </h4>
  </div>

  <div class="card-body">
    <?php if (!$ov): ?>
      <p class="text-muted mb-0">Aucun ordre de versement généré.</p>
    <?php else: ?>
      <p><strong>OV # :</strong> <?= (int)$ov['id'] ?></p>
      <p><strong>Montant :</strong> <?= number_format($ov['amount'], 0, ' ', ' ') ?> DA</p>
      <p><strong>Statut :</strong> <?= e($ov['status']) ?></p>

      <a href="<?= e(base_url('/public/payment_orders/show.php?id='.$ov['id'])) ?>"
         class="btn btn-info btn-sm mt-2">
        <i class="fas fa-eye"></i> Voir l’OV
      </a>
    <?php endif; ?>
  </div>
</div>

<!-- =======================
     ACTIONS
     ======================= -->
<div class="mb-4">

<?php if ($simulation['status'] === 'en_attente'): ?>
  <a href="accept.php?id=<?= (int)$simulation['id'] ?>"
     class="btn btn-success"
     onclick="return confirm('Accepter cette simulation ?');">
    <i class="fas fa-check"></i> Accepter
  </a>
<?php endif; ?>

<?php if ($simulation['status'] === 'acceptee'): ?>
  <a href="transform.php?id=<?= (int)$simulation['id'] ?>"
     class="btn btn-primary"
     onclick="return confirm('Valider et créer la réservation ?');">
    <i class="fas fa-exchange-alt"></i> Valider
  </a>
<?php endif; ?>

<a href="<?= e(base_url('/public/simulations/index.php')) ?>"
   class="btn btn-secondary ml-2">
  Retour
</a>

</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
