<?php


ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','finance']);

$title  = "Simulations | IMMOTECH";
$active = 'simulations';

/*
  SCHÉMA RÉEL :
  simulations → client_name / client_phone
  simulations → lot_id
  lots → reference
*/

$sql = "
SELECT
    s.id,
    c.fullname AS client_name,
    c.phone AS client_phone,
    l.reference AS lot_reference,
    s.paid_percent,
    s.discount_percent,
    s.final_price,
    s.status,
    s.created_at,
    po.id AS ov_id
FROM simulations s
JOIN clients c ON c.id = s.client_id
JOIN lots l ON l.id = s.lot_id
LEFT JOIN payment_orders po ON po.simulation_id = s.id
ORDER BY s.id DESC
";

$stmt = $pdo->query($sql);
$simulations = $stmt->fetchAll(PDO::FETCH_ASSOC);




include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Liste des simulations</h3>

  <a href="<?= e(base_url('/public/simulations/create.php')) ?>"
     class="btn btn-success">
    <i class="fas fa-plus"></i> Nouvelle simulation
  </a>
</div>

<div class="card">
  <div class="card-body table-responsive p-0">
    <table class="table table-hover mb-0">
      <thead>
        <tr>
          <th>#</th>
          <th>Client</th>
          <th>Téléphone</th>
          <th>N Lot</th>
          <th>% Paiement</th>
          <th>Remise</th>
          <th>Prix final</th>
          <th>Statut</th>
          <th>Date</th>
          <th>Action</th>
        </tr>
      </thead>

  <tbody>
<?php if (empty($simulations)): ?>
    <tr>
        <td colspan="9" class="text-center text-muted">
            Aucune simulation trouvée
        </td>
    </tr>
<?php else: ?>
    <?php foreach ($simulations as $row): ?>
        <tr>
            <td><?= (int)$row['id'] ?></td>
            <td><strong><?= e($row['client_name']) ?></strong></td>
            <td><?= e($row['client_phone'] ?? '-') ?></td>
            <td><?= e($row['lot_reference']) ?></td>
            <td><?= number_format($row['paid_percent'], 2) ?> %</td>
            <td style="color:red;"><?= number_format($row['discount_percent'], 2) ?> %</td>
            <td><strong><?= number_format($row['final_price'], 2, ',', ' ') ?> DA</strong></td>

            <td>
                <?php if ($row['status'] === 'en_attente'): ?>
                    <span class="badge badge-secondary">En attente</span>
                <?php elseif ($row['status'] === 'acceptee'): ?>
                    <span class="badge badge-success">Acceptée</span>
                <?php else: ?>
                    <span class="badge badge-primary">Validée</span>
                <?php endif; ?>
            </td>

            <td><?= date('Y-m-d H:i', strtotime($row['created_at'])) ?></td>
                

            <td>
                      <a href="<?= e(base_url('/public/simulations/show.php')) ?>?id=<?= (int)$row['id'] ?>"
                           class="btn btn-sm btn-secondary">
                          <i class="fas fa-eye"></i> Voir
                        </a>



                <?php if ($row['status'] === 'en_attente'): ?>
                    <a href="accept.php?id=<?= $row['id'] ?>"
                       class="btn btn-success btn-sm"
                       onclick="return confirm('Confirmer l’acceptation de cette simulation ?');">
                         Accepter
                    </a>
                <?php endif; ?>
                <?php if ($row['status'] === 'acceptee'): ?>
                    <a href="transform.php?id=<?= $row['id'] ?>"
                       class="btn btn-primary btn-sm"
                       onclick="return confirm('Transformer cette simulation en réservation ?');">
                         Valider
                    </a>
                <?php endif; ?>

                <a href="delete.php?id=<?= $row['id'] ?>" class="btn btn-danger btn-sm">
                    <i class="fas fa-trash"></i>
                </a>
                <?php if (
                    isset($row['ov_id']) &&
                    $row['status'] === 'transformee' &&
                    !empty($row['ov_id'])
                ): ?>
                    <a href="../../public/payment_orders/show.php?id=<?= (int)$row['ov_id'] ?>"
                       class="btn btn-info btn-sm">
                         OV
                    </a>
                <?php endif; ?>
                <?php if (in_array($row['status'], ['en_attente','acceptee'])): ?>
                <a href="cancel.php?id=<?= $row['id'] ?>"
                   class="btn btn-warning btn-sm"
                   onclick="return confirm('Annuler cette simulation ?');">
                    Annuler
                </a>
            <?php endif; ?>


            </td>
        </tr>
    <?php endforeach; ?>
<?php endif; ?>
</tbody>

    </table>
  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
