<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json');

require_once __DIR__ . '/../../app/config/database.php';

try {

    if (!isset($pdo)) {
        throw new Exception('Connexion PDO absente');
    }

    $project_id = (int)($_GET['project_id'] ?? 0);

    if ($project_id <= 0) {
        echo json_encode([]);
        exit;
    }

    $stmt = $pdo->prepare("
        SELECT id, reference, price
        FROM lots
        WHERE project_id = ?
          AND status = 'disponible'
        ORDER BY reference
    ");

    $stmt->execute([$project_id]);
    $lots = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($lots);
    exit;

} catch (Throwable $e) {

    http_response_code(500);
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage()
    ]);
    exit;
}
