<?php
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';
require_once __DIR__ . '/../../app/core/Audit.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager']);

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    redirect('/public/simulations/index.php');
}

// Charger simulation
$stmt = $pdo->prepare("SELECT * FROM simulations WHERE id=?");
$stmt->execute([$id]);
$sim = $stmt->fetch();

if (!$sim) {
    redirect('/public/simulations/index.php');
}

// Si déjà annulée → rien à faire
if ($sim['status'] === 'annulee') {
    redirect('/public/simulations/index.php');
}

// Soft delete
$upd = $pdo->prepare("
  UPDATE simulations
  SET status = 'annulee'
  WHERE id = ?
");
$upd->execute([$id]);

// Audit
$commercial_id = null;
if ($sim['client_id']) {
    $c = $pdo->prepare("SELECT owner_user_id FROM clients WHERE id=?");
    $c->execute([(int)$sim['client_id']]);
    $commercial_id = (int)($c->fetchColumn() ?: 0);
}

Audit::log([
    'client_id'     => $sim['client_id'] ?: null,
    'commercial_id' => $commercial_id ?: null,
    'action_type'   => 'delete_simulation',
    'entity_type'   => 'simulation',
    'entity_id'     => $id,
    'description'   => 'Simulation annulée (soft delete)'
]);

redirect('/public/simulations/index.php');
