<?php
/******************** INCLUDES ********************/
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

/******************** VALIDATION ID ********************/
$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    redirect('/public/simulations/index.php');
    exit;
}

/******************** UPDATE SÉCURISÉ ********************/
$stmt = $pdo->prepare("
    UPDATE simulations
    SET status = 'acceptee'
    WHERE id = ?
      AND status = 'en_attente'
");

$stmt->execute([$id]);

/******************** CONTRÔLE ********************/
if ($stmt->rowCount() === 0) {
    // Rien modifié = statut incorrect ou ID invalide
    // Optionnel : message flash
    redirect('/public/simulations/index.php?error=invalid_status');
    exit;
}

/******************** REDIRECTION ********************/
redirect('/public/simulations/index.php?success=accepted');
exit;
