<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','finance']);

$reservation_id = (int)($_GET['id'] ?? 0);
if ($reservation_id <= 0) {
    redirect('/public/reservations/index.php');
}

$title  = "Détail réservation";
$active = 'reservations';

/* ============================
   RÉSERVATION + CONTEXTE
   ============================ */
$sql = "
SELECT
    r.*,

    l.reference AS lot_reference,
    l.price     AS lot_price,
    lt.name     AS lot_type,

    p.name      AS project_name,

    c.id        AS client_id,
    c.fullname  AS client_name,
    c.phone     AS client_phone,

    s.id        AS simulation_id,
    s.final_price

FROM reservations r
JOIN lots l        ON l.id = r.lot_id
JOIN lot_types lt  ON lt.id = l.lot_type_id
JOIN projects p    ON p.id = l.project_id

LEFT JOIN clients c     ON c.id = r.client_id
LEFT JOIN simulations s ON s.id = r.simulation_id

WHERE r.id = ?
";

$stmt = $pdo->prepare($sql);
$stmt->execute([$reservation_id]);
$res = $stmt->fetch();

if (!$res) {
    redirect('/public/reservations/index.php');
}

/* ============================
   TOTAL PAYÉ (tous OVs)
   ============================ */
$total_paid = 0;
if (!empty($res['simulation_id'])) {
    $stmt = $pdo->prepare("
        SELECT IFNULL(SUM(pay.amount),0)
        FROM payment_orders po
        JOIN payments pay ON pay.payment_order_id = po.id
        WHERE po.simulation_id = ?
    ");
    $stmt->execute([$res['simulation_id']]);
    $total_paid = (float)$stmt->fetchColumn();
}

$total_price = (float)$res['final_price'];
$reste       = max($total_price - $total_paid, 0);

$expired = strtotime($res['expires_at']) < time();

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<!-- ============================
     INFOS GÉNÉRALES
     ============================ -->
<div class="card mb-3">
  <div class="card-header">
    <h3 class="card-title">
      <i class="fas fa-bookmark"></i>
      Réservation #<?= (int)$res['id'] ?>
    </h3>
  </div>

  <div class="card-body">
    <div class="row">

      <div class="col-md-6">
        <p><strong>Projet :</strong> <?= e($res['project_name']) ?></p>
        <p><strong>Lot :</strong> <?= e($res['lot_type']) ?> – <?= e($res['lot_reference']) ?></p>
        <p><strong>Prix du lot :</strong>
          <?= number_format($res['lot_price'], 0, ' ', ' ') ?> DA
        </p>
      </div>

      <div class="col-md-6">
        <p><strong>Client :</strong> <?= e($res['client_name'] ?? '-') ?></p>
        <p><strong>Téléphone :</strong> <?= e($res['client_phone'] ?? '-') ?></p>
        <p><strong>Date réservation :</strong>
          <?= date('d/m/Y', strtotime($res['reserved_at'])) ?>
        </p>
        <p><strong>Date expiration :</strong>
          <?= date('d/m/Y', strtotime($res['expires_at'])) ?>
        </p>
      </div>

    </div>
  </div>
</div>

<!-- ============================
     STATUT
     ============================ -->
<div class="card mb-3">
  <div class="card-body">

    <p>
      <strong>Statut réservation :</strong>
      <?php
        if ($expired && $res['status'] === 'en_attente') {
            $badge = 'secondary';
            $label = 'Expirée';
        } else {
            switch ($res['status']) {
                case 'confirmee': $badge = 'info';    $label = 'Confirmée'; break;
                case 'vendue':    $badge = 'success'; $label = 'Vendue'; break;
                case 'annulee':   $badge = 'danger';  $label = 'Annulée'; break;
                default:          $badge = 'warning'; $label = 'En attente';
            }
        }
      ?>
      <span class="badge badge-<?= $badge ?>"><?= $label ?></span>
    </p>

  </div>
</div>

<!-- ============================
     FINANCIER
     ============================ -->
<div class="card mb-3">
  <div class="card-header">
    <h4 class="card-title">
      <i class="fas fa-money-bill"></i> Situation financière
    </h4>
  </div>

  <div class="card-body">
    <div class="row">

      <div class="col-md-4">
        <p><strong>Montant total :</strong><br>
          <?= number_format($total_price, 0, ' ', ' ') ?> DA
        </p>
      </div>

      <div class="col-md-4">
        <p><strong>Total payé :</strong><br>
          <?= number_format($total_paid, 0, ' ', ' ') ?> DA
        </p>
      </div>

      <div class="col-md-4">
        <p><strong>Reste à payer :</strong><br>
          <?= number_format($reste, 0, ' ', ' ') ?> DA
        </p>
      </div>

    </div>
  </div>
</div>

<!-- ============================
     ACTIONS MÉTIER
     ============================ -->
<div class="card">
  <div class="card-body">

    <?php if (!empty($res['simulation_id'])): ?>
      <a class="btn btn-primary"
         href="<?= e(base_url('/public/payment_orders/index.php?simulation_id='.$res['simulation_id'])) ?>">
        <i class="fas fa-file-invoice"></i> Ordres de versement
      </a>
    <?php endif; ?>

    <?php if ($reste > 0 && !$expired): ?>
      <a class="btn btn-success"
         href="<?= e(base_url('/public/payments/create.php?reservation_id='.$res['id'])) ?>">
        <i class="fas fa-cash-register"></i> Encaisser paiement
      </a>
    <?php endif; ?>

    <?php if ($res['status'] === 'en_attente'): ?>
      <a class="btn btn-info"
         href="<?= e(base_url('/public/reservations/confirm.php?id='.$res['id'])) ?>">
        Confirmer
      </a>
    <?php endif; ?>

    <?php if (in_array($res['status'], ['en_attente','confirmee'])): ?>
      <a class="btn btn-danger"
         href="<?= e(base_url('/public/reservations/cancel.php?id='.$res['id'])) ?>">
        Annuler
      </a>
    <?php endif; ?>

    <?php if ($reste == 0 && $res['status'] === 'confirmee'): ?>
      <a class="btn btn-dark"
         href="<?= e(base_url('/public/reservations/sell.php?id='.$res['id'])) ?>">
        <i class="fas fa-check"></i> Vendre le lot
      </a>
    <?php endif; ?>

    <a class="btn btn-secondary float-right"
       href="<?= e(base_url('/public/reservations/index.php')) ?>">
      Retour
    </a>

  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
