<?php
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) exit('ID invalide');

$pdo->beginTransaction();

try {
    $stmt = $pdo->prepare("
        SELECT r.client_id, r.lot_id, s.final_price
        FROM reservations r
        JOIN simulations s ON s.id = r.simulation_id
        WHERE r.id = ?
    ");
    $stmt->execute([$id]);
    $res = $stmt->fetch();

    if (!$res) throw new Exception('Réservation introuvable');

    $stmt = $pdo->prepare("
        SELECT IFNULL(SUM(pay.amount),0)
        FROM payment_orders po
        JOIN payments pay ON pay.payment_order_id = po.id
        WHERE po.simulation_id = ?
    ");
    $stmt->execute([$res['simulation_id'] ?? 0]);
    $paid = (float)$stmt->fetchColumn();

    if ($paid < (float)$res['final_price']) {
        throw new Exception('Paiement incomplet');
    }

    $pdo->prepare("
        UPDATE reservations
        SET status = 'vendue', sold_at = NOW()
        WHERE id = ?
    ")->execute([$id]);

    $pdo->prepare("
        UPDATE lots SET status = 'vendu'
        WHERE id = ?
    ")->execute([$res['lot_id']]);

    if ($res['client_id']) {
        $pdo->prepare("
            UPDATE clients SET status = 'client'
            WHERE id = ?
        ")->execute([$res['client_id']]);
    }

    $pdo->commit();
    header("Location: show.php?id=$id");

} catch (Exception $e) {
    $pdo->rollBack();
    die($e->getMessage());
}
