<?php
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$q = trim($_GET['q'] ?? '');

$where = '';
$params = [];

if ($q !== '') {
    $where = "
        WHERE
            c.fullname LIKE ?
            OR l.reference LIKE ?
    ";
    $like = "%$q%";
    $params = [$like, $like];
}

$sql = "
SELECT
    r.id,
    r.status,
    r.reserved_at,
    r.expires_at,

    c.fullname AS client_name,

    l.reference AS lot_reference,
    lt.name AS lot_type,

    p.name AS project_name,

    s.id AS simulation_id,

    DATEDIFF(r.expires_at, NOW()) AS days_left

FROM reservations r
JOIN clients c ON c.id = r.client_id
JOIN lots l ON l.id = r.lot_id
JOIN lot_types lt ON lt.id = l.lot_type_id
JOIN projects p ON p.id = l.project_id
JOIN simulations s ON s.id = r.simulation_id
" . $where . "
ORDER BY r.id DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$reservations = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$reservations) {
    echo '<tr><td colspan="8" class="text-center text-muted">Aucun résultat</td></tr>';
    exit;
}

foreach ($reservations as $r) {

    // Badge statut
    switch ($r['status']) {
        case 'confirmee': $badge = 'info'; break;
        case 'vendue':    $badge = 'success'; break;
        case 'livree':    $badge = 'dark'; break;
        case 'expiree':   $badge = 'danger'; break;
        default:          $badge = 'secondary';
    }

    // Expiration
    $expireLabel = '-';
    if ($r['status'] === 'confirmee') {
        if ($r['days_left'] < 0) {
            $expireLabel = '<span class="text-danger">Expirée</span>';
        } else {
            $expireLabel = $r['days_left'].' j';
        }
    }

    echo '<tr>';
    echo '<td>'.$r['id'].'</td>';
    echo '<td><strong>'.e($r['client_name']).'</strong></td>';
    echo '<td><strong>'.e($r['project_name']).'</strong></td>';
    echo '<td>'.e($r['lot_type'].' - '.$r['lot_reference']).'</td>';
    echo '<td>'.date('d/m/Y', strtotime($r['reserved_at'])).'</td>';
    echo '<td>'.$expireLabel.'</td>';
    echo '<td><span class="badge badge-'.$badge.'">'.ucfirst($r['status']).'</span></td>';
    echo '<td>

        <a class="btn btn-sm btn-secondary"
           href="'.base_url('/public/reservations/show.php?id='.$r['id']).'">
          <i class="fas fa-eye"></i>
        </a>

        <a class="btn btn-sm btn-info"
           href="'.base_url('/public/payment_orders/index.php?simulation_id='.$r['simulation_id']).'">
          <i class="fas fa-file-invoice"></i>
        </a>

        <a class="btn btn-sm btn-success"
           href="'.base_url('/public/payments/index.php?simulation_id='.$r['simulation_id']).'">
          <i class="fas fa-money-bill"></i>
        </a>

        <a class="btn btn-sm btn-warning"
           href="'.base_url('/public/reserves/index.php?reservation_id='.$r['id']).'">
          <i class="fas fa-tools"></i>
        </a>

    </td>';
    echo '</tr>';
}
