<?php
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) redirect('/public/reservations/index.php');

$stmt = $pdo->prepare("
    SELECT r.*, l.reference, s.final_price
    FROM reservations r
    JOIN lots l ON l.id = r.lot_id
    JOIN simulations s ON s.id = r.simulation_id
    WHERE r.id = ?
");
$stmt->execute([$id]);
$r = $stmt->fetch();

if (!$r) redirect('/public/reservations/index.php');
?>

<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Ordre de versement</title>
<style>
body{font-family:Arial}
.container{width:800px;margin:auto}
table{width:100%;border-collapse:collapse}
td,th{border:1px solid #000;padding:8px}
</style>
</head>
<body>

<div class="container">
<h2 align="center">ORDRE DE VERSEMENT</h2>

<p><strong>Date :</strong> <?= date('d/m/Y') ?></p>

<table>
<tr><th>Client</th><td><?= e($r['client_name']) ?></td></tr>
<tr><th>Lot</th><td><?= e($r['reference']) ?></td></tr>
<tr><th>Prix final</th><td><?= number_format($r['final_price'],0,' ',' ') ?> DA</td></tr>
<tr>
  <th>Montant à verser (<?= $r['first_installment_percent'] ?> %)</th>
  <td><strong><?= number_format($r['first_installment_amount'],0,' ',' ') ?> DA</strong></td>
</tr>
<tr><th>Date limite</th><td><?= date('d/m/Y', strtotime($r['expires_at'])) ?></td></tr>
</table>

<p style="margin-top:40px">
Ce document constitue un ordre de versement et non une preuve de paiement.
</p>

<script>window.print()</script>
</div>
</body>
</html>
