<?php
/******************** DEBUG ********************/
ini_set('display_errors', 1);
error_reporting(E_ALL);

/******************** INCLUDES ********************/
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','finance']);

$title  = "Réservations | IMMOTECH";
$active = 'reservations';

/******************** FILTRES ********************/
$status = $_GET['status'] ?? '';
$where  = [];
$params = [];

if ($status !== '') {
    $where[]  = "r.status = ?";
    $params[] = $status;
}

/******************** REQUÊTE ********************/
$sql = "
SELECT
    r.id,
    r.status,
    r.reserved_at,
    r.expires_at,
    r.first_installment_amount,

    c.fullname AS client_name,

    l.reference AS lot_reference,
    lt.name AS lot_type,

    p.name AS project_name,

    s.id AS simulation_id,

    DATEDIFF(r.expires_at, NOW()) AS days_left

FROM reservations r
JOIN clients c ON c.id = r.client_id
JOIN lots l ON l.id = r.lot_id
JOIN lot_types lt ON lt.id = l.lot_type_id
JOIN projects p ON p.id = l.project_id
JOIN simulations s ON s.id = r.simulation_id
" . ($where ? " WHERE " . implode(" AND ", $where) : "") . "
ORDER BY r.id DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$reservations = $stmt->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<!-- =========================
     HEADER + FILTRES
     ========================= -->
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Réservations</h3>

  <div>
    <a href="?status=" class="btn btn-sm btn-secondary">Toutes</a>
    <a href="?status=confirmee" class="btn btn-sm btn-info">Confirmées</a>
    <a href="?status=vendue" class="btn btn-sm btn-success">Vendues</a>
    <a href="?status=livree" class="btn btn-sm btn-dark">Livrées</a>
    <a href="?status=expiree" class="btn btn-sm btn-danger">Expirées</a>
  </div>
</div>


<div class="mb-3 d-flex gap-2">
  <a href="export_excel.php?<?= http_build_query($_GET) ?>"
     class="btn btn-success btn-sm">
    <i class="fas fa-file-excel"></i> Export Excel
  </a>

  <a href="export_pdf.php?<?= http_build_query($_GET) ?>"
     class="btn btn-danger btn-sm">
    <i class="fas fa-file-pdf"></i> Export PDF
  </a>
</div>


<div class="card mb-3">
  <div class="card-body">
    <input type="text"
           id="searchReservation"
           class="form-control"
           placeholder="🔎 Rechercher par client ou N° du lot...">
  </div>
</div>


<div class="card">
<div class="card-body table-responsive p-0">



<table  class="table table-hover mb-0">
<thead>
<tr>
  <th>#</th>
  <th>Client</th>
  <th>Projet</th>
  <th>Type et N Lot</th>
  <th>Date réservation</th>
  <th>Expiration</th>
  <th>Statut</th>
  <th>Actions</th>
</tr>
</thead>

<tbody id="reservationsTable">
<?php if (!$reservations): ?>
<tr>
  <td colspan="8" class="text-center text-muted p-4">
    Aucune réservation
  </td>
</tr>
<?php else: foreach ($reservations as $r): ?>

<?php
// Badge statut
switch ($r['status']) {
    case 'confirmee': $badge = 'info'; break;
    case 'vendue':    $badge = 'success'; break;
    case 'livree':    $badge = 'dark'; break;
    case 'expiree':   $badge = 'danger'; break;
    default:          $badge = 'secondary';
}

// Expiration
$expireLabel = '-';
if ($r['status'] === 'confirmee') {
    if ($r['days_left'] < 0) {
        $expireLabel = '<span class="text-danger">Expirée</span>';
    } else {
        $expireLabel = $r['days_left'].' j';
    }
}
?>

<tr>
  <td><?= (int)$r['id'] ?></td>
  <td><strong><?= e($r['client_name']) ?></strong></td>
  <td><strong><?= e($r['project_name']) ?></strong></td>
  <td><?= e($r['lot_type'].' - '.$r['lot_reference']) ?></td>
  <td><?= date('d/m/Y', strtotime($r['reserved_at'])) ?></td>
  <td><?= $expireLabel ?></td>
  <td>
    <span class="badge badge-<?= $badge ?>">
      <?= ucfirst($r['status']) ?>
    </span>
  </td>
  <td>

    <!-- Voir -->
    <a class="btn btn-sm btn-secondary"
       href="<?= e(base_url('/public/reservations/show.php?id='.$r['id'])) ?>">
      <i class="fas fa-eye"></i>
    </a>

    <!-- OV -->
    <a class="btn btn-sm btn-info"
       href="<?= e(base_url('/public/payment_orders/index.php?simulation_id='.$r['simulation_id'])) ?>">
      <i class="fas fa-file-invoice"></i>
    </a>

    <!-- Paiements -->
    <a class="btn btn-sm btn-success"
       href="<?= e(base_url('/public/payments/index.php?simulation_id='.$r['simulation_id'])) ?>">
      <i class="fas fa-money-bill"></i>
    </a>

    <!-- Réserves -->
    <a class="btn btn-sm btn-warning"
       href="<?= e(base_url('/public/reserves/index.php?reservation_id='.$r['id'])) ?>">
      <i class="fas fa-tools"></i>
    </a>

  </td>
</tr>

<?php endforeach; endif; ?>
</tbody>
</table>

</div>
</div>

</div>

<script>
document.getElementById('searchReservation').addEventListener('keyup', function () {
    const q = this.value;

    fetch('search.php?q=' + encodeURIComponent(q))
        .then(res => res.text())
        .then(html => {
            document.getElementById('reservationsTable').innerHTML = html;
        });
});
</script>

</section>


<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
