<?php
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/lib/tcpdf/tcpdf.php';

$status = $_GET['status'] ?? '';
$q      = trim($_GET['q'] ?? '');

$where = [];
$params = [];

if ($status !== '') {
    $where[] = "r.status = ?";
    $params[] = $status;
}

if ($q !== '') {
    $where[] = "(c.fullname LIKE ? OR l.reference LIKE ?)";
    $like = "%$q%";
    $params[] = $like;
    $params[] = $like;
}

$sql = "
SELECT
    c.fullname AS client,
    p.name AS projet,
    CONCAT(lt.name,' - ',l.reference) AS lot,
    r.status,
    r.reserved_at,
    r.expires_at
FROM reservations r
JOIN clients c ON c.id = r.client_id
JOIN lots l ON l.id = r.lot_id
JOIN lot_types lt ON lt.id = l.lot_type_id
JOIN projects p ON p.id = l.project_id
" . ($where ? " WHERE ".implode(" AND ", $where) : "") . "
ORDER BY r.id DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$data = $stmt->fetchAll(PDO::FETCH_ASSOC);

$pdf = new TCPDF();
$pdf->AddPage();
$pdf->SetFont('helvetica', '', 10);

$html = '<h3>Liste des réservations</h3><table border="1" cellpadding="4">
<tr>
<th>Client</th><th>Projet</th><th>Lot</th><th>Statut</th><th>Réservé le</th>
</tr>';

foreach ($data as $r) {
    $html .= "<tr>
        <td>{$r['client']}</td>
        <td>{$r['projet']}</td>
        <td>{$r['lot']}</td>
        <td>{$r['status']}</td>
        <td>{$r['reserved_at']}</td>
    </tr>";
}

$html .= '</table>';

$pdf->writeHTML($html);
$pdf->Output('reservations.pdf', 'D');
