<?php
require_once __DIR__ . '/../../app/config/database.php';

$status = $_GET['status'] ?? '';
$q      = trim($_GET['q'] ?? '');

$where = [];
$params = [];

if ($status !== '') {
    $where[] = "r.status = ?";
    $params[] = $status;
}

if ($q !== '') {
    $where[] = "(c.fullname LIKE ? OR l.reference LIKE ?)";
    $like = "%$q%";
    $params[] = $like;
    $params[] = $like;
}

$sql = "
SELECT
    c.fullname AS client,
    p.name AS projet,
    CONCAT(lt.name,' - ',l.reference) AS lot,
    r.status,
    r.reserved_at,
    r.expires_at
FROM reservations r
JOIN clients c ON c.id = r.client_id
JOIN lots l ON l.id = r.lot_id
JOIN lot_types lt ON lt.id = l.lot_type_id
JOIN projects p ON p.id = l.project_id
" . ($where ? " WHERE ".implode(" AND ", $where) : "") . "
ORDER BY r.id DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$data = $stmt->fetchAll(PDO::FETCH_ASSOC);

header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=reservations.xls");

echo "Client\tProjet\tLot\tStatut\tDate réservation\tExpiration\n";

foreach ($data as $r) {
    echo "{$r['client']}\t{$r['projet']}\t{$r['lot']}\t{$r['status']}\t{$r['reserved_at']}\t{$r['expires_at']}\n";
}
