<?php
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) exit('ID invalide');

$pdo->beginTransaction();

try {
    $pdo->prepare("
        UPDATE reservations
        SET status = 'confirmee', updated_at = NOW()
        WHERE id = ?
    ")->execute([$id]);

    $pdo->prepare("
        UPDATE lots
        SET status = 'reserve'
        WHERE id = (SELECT lot_id FROM reservations WHERE id = ?)
    ")->execute([$id]);

    $pdo->commit();
    header("Location: show.php?id=$id");
} catch (Exception $e) {
    $pdo->rollBack();
    die($e->getMessage());
}
