<?php
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) exit('ID invalide');

$pdo->beginTransaction();

try {
    $pdo->prepare("
        UPDATE reservations
        SET status = 'annulee', updated_at = NOW()
        WHERE id = ?
    ")->execute([$id]);

    $pdo->prepare("
        UPDATE lots
        SET status = 'disponible'
        WHERE id = (SELECT lot_id FROM reservations WHERE id = ?)
    ")->execute([$id]);

    $pdo->commit();
    header("Location: index.php");
} catch (Exception $e) {
    $pdo->rollBack();
    die($e->getMessage());
}
