<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','finance']);

$active = 'purchases';
$subactive = 'purchases_list';

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
  header("Location: " . e(base_url('/public/purchases/index.php')));
  exit;
}

/** Helpers */
function statusLabel(string $st): string {
  return match ($st) {
    'DRAFT' => 'Brouillon',
    'VALIDATED' => 'Validé',
    'PARTIAL_PAID' => 'Partiellement payé',
    'PAID' => 'Payé',
    default => $st
  };
}
function statusBadge(string $st): string {
  return match ($st) {
    'PAID' => 'success',
    'PARTIAL_PAID' => 'warning',
    'VALIDATED' => 'info',
    'DRAFT' => 'secondary',
    default => 'secondary'
  };
}

/** 1) Charger achat */
$sql = "
SELECT
  pu.*,
  s.name AS supplier_name,
  p.name AS project_name
FROM purchases pu
LEFT JOIN suppliers s ON s.id = pu.supplier_id
LEFT JOIN projects  p ON p.id = pu.project_id
WHERE pu.id = ?
LIMIT 1
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$id]);
$purchase = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$purchase) {
  $title = "Achat introuvable | IMMOTECH";
  include __DIR__ . '/../../app/views/layout/header.php';
  include __DIR__ . '/../../app/views/layout/sidebar.php';
  ?>
  <section class="content pt-3">
    <div class="container-fluid">
      <div class="alert alert-warning">Achat introuvable.</div>
      <a class="btn btn-secondary" href="<?= e(base_url('/public/purchases/index.php')) ?>">
        <i class="fas fa-arrow-left mr-1"></i> Retour
      </a>
    </div>
  </section>
  <?php
  include __DIR__ . '/../../app/views/layout/footer.php';
  exit;
}

/** 2) Charger lignes */
$stmt = $pdo->prepare("
  SELECT id, purchase_id, description, qty, unit_price, total
  FROM purchase_lines
  WHERE purchase_id = ?
  ORDER BY id ASC
");
$stmt->execute([$id]);
$lines = $stmt->fetchAll(PDO::FETCH_ASSOC);

/** 3) Totaux (recalc sécurité) */
$sumLines = 0.0;
foreach ($lines as $ln) {
  $lineTotal = isset($ln['total']) ? (float)$ln['total'] : ((float)$ln['qty'] * (float)$ln['unit_price']);
  $sumLines += $lineTotal;
}
$sumLines = round($sumLines, 2);

$total_ht  = isset($purchase['total_ht'])  ? (float)$purchase['total_ht']  : $sumLines;
$total_ttc = isset($purchase['total_ttc']) ? (float)$purchase['total_ttc'] : $total_ht;

/** 4) Paiements */
$payments = [];
$paid_total = 0.0;

try {
  $stmt = $pdo->prepare("
    SELECT id, payment_date, amount, method, reference, note, created_at
    FROM purchase_payments
    WHERE purchase_id = ?
    ORDER BY payment_date DESC, id DESC
  ");
  $stmt->execute([$id]);
  $payments = $stmt->fetchAll(PDO::FETCH_ASSOC);

  $stmt = $pdo->prepare("SELECT COALESCE(SUM(amount),0) FROM purchase_payments WHERE purchase_id = ?");
  $stmt->execute([$id]);
  $paid_total = (float)$stmt->fetchColumn();
} catch (Exception $e) {
  $payments = [];
  $paid_total = 0.0;
}

$remaining = max(0, round($total_ttc - $paid_total, 2));

/** 5) Stock posted */
$stock_posted = (int)($purchase['stock_posted'] ?? 0);
$stock_posted_at = $purchase['stock_posted_at'] ?? null;

$title = "Achat #{$purchase['id']} | IMMOTECH";

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
  <div class="container-fluid">

    <div class="d-flex justify-content-between align-items-center mb-3">
      <div>
        <h3 class="mb-0">Détail achat #<?= (int)$purchase['id'] ?></h3>
        <small class="text-muted">
          Créé le : <?= e($purchase['created_at'] ?? '-') ?>
        </small>
      </div>

      <div class="d-flex" style="gap:8px;">
        <a class="btn btn-secondary" href="<?= e(base_url('/public/purchases/index.php')) ?>">
          <i class="fas fa-arrow-left mr-1"></i> Retour
        </a>

        <a class="btn btn-warning" href="<?= e(base_url('/public/purchases/edit.php?id=' . (int)$purchase['id'])) ?>">
          <i class="fas fa-edit mr-1"></i> Modifier
        </a>

        <a class="btn btn-danger"
           onclick="return confirm('Supprimer cet achat ?');"
           href="<?= e(base_url('/public/purchases/delete.php?id=' . (int)$purchase['id'])) ?>">
          <i class="fas fa-trash mr-1"></i> Supprimer
        </a>
      </div>
    </div>

    <div class="row">

      <!-- Infos facture -->
      <div class="col-lg-8">
        <div class="card card-outline card-primary">
          <div class="card-header">
            <h5 class="card-title mb-0">Informations facture</h5>
          </div>
          <div class="card-body">

            <div class="row">
              <div class="col-md-6">
                <p class="mb-1 text-muted">Fournisseur</p>
                <h5 class="mb-2"><?= e($purchase['supplier_name'] ?? '-') ?></h5>

                <div class="text-muted">
                  <span>Projet :</span>
                  <strong><?= e($purchase['project_name'] ?? '-') ?></strong>
                </div>

                <div class="mt-2">
                  <?php if ($stock_posted === 1): ?>
                    <span class="badge badge-success">
                      <i class="fas fa-check mr-1"></i> Stock posté
                    </span>
                    <?php if ($stock_posted_at): ?>
                      <small class="text-muted ml-2">le <?= e($stock_posted_at) ?></small>
                    <?php endif; ?>
                  <?php else: ?>
                    <span class="badge badge-secondary">
                      <i class="fas fa-box mr-1"></i> Stock non posté
                    </span>
                  <?php endif; ?>
                </div>

              </div>

              <div class="col-md-6">
                <div class="mb-2">
                  <span class="text-muted">Date facture :</span>
                  <strong><?= e($purchase['invoice_date'] ?? '-') ?></strong>
                </div>

                <div class="mb-2">
                  <span class="text-muted">N° facture :</span>
                  <strong><?= e($purchase['invoice_no'] ?? '-') ?></strong>
                </div>

                <?php $b = statusBadge((string)($purchase['status'] ?? '')); ?>
                <span class="badge badge-<?= e($b) ?>" style="font-size: 14px;">
                  <?= e(statusLabel((string)($purchase['status'] ?? ''))) ?>
                </span>
              </div>
            </div>

            <?php if (!empty($purchase['note'])): ?>
              <hr>
              <p class="mb-1 text-muted">Note</p>
              <div class="p-2 bg-light border rounded">
                <?= nl2br(e($purchase['note'])) ?>
              </div>
            <?php endif; ?>

          </div>
        </div>
      </div>

      <!-- Totaux + Paiements -->
      <div class="col-lg-4">
        <div class="card card-outline card-info">
          <div class="card-header">
            <h5 class="card-title mb-0">Totaux & Paiements</h5>
          </div>
          <div class="card-body">

            <div class="d-flex justify-content-between">
              <span class="text-muted">Total lignes</span>
              <strong><?= number_format($sumLines, 2, ',', ' ') ?></strong>
            </div>

            <hr class="my-2">

            <div class="d-flex justify-content-between">
              <span class="text-muted">Total HT</span>
              <strong><?= number_format($total_ht, 2, ',', ' ') ?></strong>
            </div>

            <div class="d-flex justify-content-between">
              <span class="text-muted">Total TTC</span>
              <strong><?= number_format($total_ttc, 2, ',', ' ') ?></strong>
            </div>

            <hr class="my-2">

            <div class="d-flex justify-content-between">
              <span class="text-muted">Payé</span>
              <strong><?= number_format($paid_total, 2, ',', ' ') ?></strong>
            </div>

            <div class="d-flex justify-content-between">
              <span class="text-muted">Reste</span>
              <strong><?= number_format($remaining, 2, ',', ' ') ?></strong>
            </div>

            <?php if (abs($sumLines - $total_ht) > 0.01): ?>
              <div class="alert alert-warning mt-3 mb-0">
                Attention : total lignes ≠ total HT.
              </div>
            <?php endif; ?>

            <div class="mt-3">
              <a class="btn btn-success btn-block"
                 href="<?= e(base_url('/public/purchases/payment_create.php?purchase_id=' . (int)$purchase['id'])) ?>">
                <i class="fas fa-plus mr-1"></i> Ajouter paiement
              </a>
            </div>

          </div>
        </div>
      </div>

    </div>

    <!-- Lignes d'achat -->
    <div class="card card-outline card-secondary">
      <div class="card-header">
        <h5 class="card-title mb-0">Lignes d’achat</h5>
      </div>
      <div class="card-body table-responsive p-0">
        <table class="table table-hover mb-0">
          <thead>
            <tr>
              <th>#</th>
              <th>Description</th>
              <th class="text-right">Qté</th>
              <th class="text-right">PU</th>
              <th class="text-right">Total</th>
            </tr>
          </thead>
          <tbody>
            <?php if (!$lines): ?>
              <tr>
                <td colspan="5" class="text-center text-muted p-4">Aucune ligne.</td>
              </tr>
            <?php else: ?>
              <?php foreach ($lines as $i => $ln): ?>
                <tr>
                  <td><?= (int)($i + 1) ?></td>
                  <td><?= e($ln['description'] ?? '') ?></td>
                  <td class="text-right"><?= number_format((float)$ln['qty'], 2, ',', ' ') ?></td>
                  <td class="text-right"><?= number_format((float)$ln['unit_price'], 2, ',', ' ') ?></td>
                  <td class="text-right"><strong><?= number_format((float)$ln['total'], 2, ',', ' ') ?></strong></td>
                </tr>
              <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

    <!-- Paiements -->
    <div class="card card-outline card-success">
      <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">Historique des paiements</h5>
        <a class="btn btn-sm btn-success"
           href="<?= e(base_url('/public/purchases/payment_create.php?purchase_id=' . (int)$purchase['id'])) ?>">
          <i class="fas fa-plus mr-1"></i> Ajouter paiement
        </a>
      </div>

      <div class="card-body table-responsive p-0">
        <table class="table table-hover mb-0">
          <thead>
            <tr>
              <th>Date</th>
              <th class="text-right">Montant</th>
              <th>Méthode</th>
              <th>Référence</th>
              <th>Note</th>
              <th style="width:90px;">Action</th>
            </tr>
          </thead>
          <tbody>
          <?php if (!$payments): ?>
            <tr>
              <td colspan="6" class="text-center text-muted p-4">Aucun paiement.</td>
            </tr>
          <?php else: foreach ($payments as $pay): ?>
            <tr>
              <td><?= e($pay['payment_date'] ?? '-') ?></td>
              <td class="text-right"><strong><?= number_format((float)$pay['amount'], 2, ',', ' ') ?></strong></td>
              <td><?= e($pay['method'] ?? '-') ?></td>
              <td><?= e($pay['reference'] ?? '-') ?></td>
              <td><?= e($pay['note'] ?? '-') ?></td>
              <td>
                <a class="btn btn-sm btn-danger"
                   onclick="return confirm('Supprimer ce paiement ?');"
                   href="<?= e(base_url('/public/purchases/payment_delete.php?id=' . (int)$pay['id'] . '&purchase_id=' . (int)$purchase['id'])) ?>">
                  <i class="fas fa-trash"></i>
                </a>
              </td>
            </tr>
          <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>

  </div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
