<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','finance']);

$id = (int)($_GET['id'] ?? 0);
$purchase_id = (int)($_GET['purchase_id'] ?? 0);

if ($id <= 0 || $purchase_id <= 0) {
  header("Location: " . e(base_url('/public/purchases/index.php')));
  exit;
}

try {
  $pdo->beginTransaction();

  // delete paiement
  $stmt = $pdo->prepare("DELETE FROM purchase_payments WHERE id=? AND purchase_id=?");
  $stmt->execute([$id, $purchase_id]);

  // recalcul payé
  $stmt = $pdo->prepare("SELECT total_ttc, status FROM purchases WHERE id=? LIMIT 1");
  $stmt->execute([$purchase_id]);
  $purchase = $stmt->fetch(PDO::FETCH_ASSOC);

  if ($purchase) {
    $stmt = $pdo->prepare("SELECT COALESCE(SUM(amount),0) FROM purchase_payments WHERE purchase_id=?");
    $stmt->execute([$purchase_id]);
    $paid_total = (float)$stmt->fetchColumn();
    $ttc = (float)$purchase['total_ttc'];

    if ($paid_total >= $ttc && $ttc > 0) $newStatus = 'PAID';
    elseif ($paid_total > 0) $newStatus = 'PARTIAL_PAID';
    else $newStatus = ($purchase['status'] === 'DRAFT' ? 'DRAFT' : 'VALIDATED');

    $stmt = $pdo->prepare("UPDATE purchases SET status=? WHERE id=?");
    $stmt->execute([$newStatus, $purchase_id]);
  }

  $pdo->commit();

} catch (Exception $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
}

header("Location: " . e(base_url('/public/purchases/show.php?id=' . $purchase_id)));
exit;
