<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','finance']);

$active = 'purchases';
$subactive = 'purchases_list';
$title = "Ajouter paiement | IMMOTECH";

$purchase_id = (int)($_GET['purchase_id'] ?? 0);
if ($purchase_id <= 0) {
  header("Location: " . e(base_url('/public/purchases/index.php')));
  exit;
}

// Charger achat
$stmt = $pdo->prepare("SELECT pu.*, s.name AS supplier_name FROM purchases pu LEFT JOIN suppliers s ON s.id=pu.supplier_id WHERE pu.id=?");
$stmt->execute([$purchase_id]);
$purchase = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$purchase) {
  header("Location: " . e(base_url('/public/purchases/index.php')));
  exit;
}

// Total payé
$stmt = $pdo->prepare("SELECT COALESCE(SUM(amount),0) FROM purchase_payments WHERE purchase_id=?");
$stmt->execute([$purchase_id]);
$paid_total = (float)$stmt->fetchColumn();
$remaining = max(0, round(((float)$purchase['total_ttc']) - $paid_total, 2));

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $payment_date = $_POST['payment_date'] ?? date('Y-m-d');
  $amount = (float)str_replace(',', '.', (string)($_POST['amount'] ?? '0'));
  $method = trim((string)($_POST['method'] ?? ''));
  $reference = trim((string)($_POST['reference'] ?? ''));
  $note = trim((string)($_POST['note'] ?? ''));

  if ($amount <= 0) $errors[] = "Montant doit être > 0.";
  if (!$payment_date) $errors[] = "Date obligatoire.";

  if (!$errors) {
    try {
      $pdo->beginTransaction();

      // insert paiement
      $stmt = $pdo->prepare("INSERT INTO purchase_payments (purchase_id, payment_date, amount, method, reference, note)
                             VALUES (:pid,:d,:a,:m,:r,:n)");
      $stmt->execute([
        ':pid' => $purchase_id,
        ':d' => $payment_date,
        ':a' => $amount,
        ':m' => $method !== '' ? $method : null,
        ':r' => $reference !== '' ? $reference : null,
        ':n' => $note !== '' ? $note : null,
      ]);

      // recalcul payé
      $stmt = $pdo->prepare("SELECT COALESCE(SUM(amount),0) FROM purchase_payments WHERE purchase_id=?");
      $stmt->execute([$purchase_id]);
      $paid_total2 = (float)$stmt->fetchColumn();
      $ttc = (float)$purchase['total_ttc'];

      // statut auto
      if ($paid_total2 >= $ttc && $ttc > 0) $newStatus = 'PAID';
      elseif ($paid_total2 > 0) $newStatus = 'PARTIAL_PAID';
      else $newStatus = ($purchase['status'] === 'DRAFT' ? 'DRAFT' : 'VALIDATED');

      $stmt = $pdo->prepare("UPDATE purchases SET status=? WHERE id=?");
      $stmt->execute([$newStatus, $purchase_id]);

      $pdo->commit();

      header("Location: " . e(base_url('/public/purchases/show.php?id=' . $purchase_id)));
      exit;

    } catch (Exception $e) {
      if ($pdo->inTransaction()) $pdo->rollBack();
      $errors[] = "Erreur: " . $e->getMessage();
    }
  }
}

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
  <div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <div>
        <h3 class="mb-0">Ajouter paiement</h3>
        <small class="text-muted">Achat #<?= (int)$purchase['id'] ?> — <?= e($purchase['supplier_name'] ?? '-') ?></small>
      </div>
      <a class="btn btn-secondary" href="<?= e(base_url('/public/purchases/show.php?id=' . (int)$purchase_id)) ?>">
        <i class="fas fa-arrow-left mr-1"></i> Retour
      </a>
    </div>

    <?php if ($errors): ?>
      <div class="alert alert-danger">
        <ul class="mb-0 pl-3">
          <?php foreach ($errors as $er): ?><li><?= e($er) ?></li><?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>

    <div class="card">
      <div class="card-body">
        <div class="mb-3">
          <div><b>Total TTC:</b> <?= number_format((float)$purchase['total_ttc'], 2, ',', ' ') ?></div>
          <div><b>Déjà payé:</b> <?= number_format((float)$paid_total, 2, ',', ' ') ?></div>
          <div><b>Reste:</b> <?= number_format((float)$remaining, 2, ',', ' ') ?></div>
        </div>

        <form method="post">
          <div class="row">
            <div class="col-md-3">
              <label>Date paiement</label>
              <input type="date" class="form-control" name="payment_date" value="<?= e($_POST['payment_date'] ?? date('Y-m-d')) ?>" required>
            </div>
            <div class="col-md-3">
              <label>Montant</label>
              <input type="number" step="0.01" class="form-control" name="amount" value="<?= e($_POST['amount'] ?? '') ?>" required>
            </div>
            <div class="col-md-3">
              <label>Méthode</label>
              <input type="text" class="form-control" name="method" placeholder="Virement, Espèces..." value="<?= e($_POST['method'] ?? '') ?>">
            </div>
            <div class="col-md-3">
              <label>Référence</label>
              <input type="text" class="form-control" name="reference" placeholder="N° chèque / ref virement" value="<?= e($_POST['reference'] ?? '') ?>">
            </div>
          </div>

          <div class="mt-3">
            <label>Note</label>
            <textarea class="form-control" name="note" rows="2"><?= e($_POST['note'] ?? '') ?></textarea>
          </div>

          <div class="mt-3 d-flex justify-content-end">
            <button class="btn btn-success"><i class="fas fa-save mr-1"></i> Enregistrer</button>
          </div>
        </form>

      </div>
    </div>
  </div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
