<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','finance']);

$title = "Achats | IMMOTECH";
$active = 'purchases';
$subactive = 'purchases_list';

$q          = trim($_GET['q'] ?? '');
$project_id = (int)($_GET['project_id'] ?? 0);
$supplier_id= (int)($_GET['supplier_id'] ?? 0);
$status     = trim($_GET['status'] ?? '');

$allowedStatuses = ['DRAFT','VALIDATED','PARTIAL_PAID','PAID'];
if ($status !== '' && !in_array($status, $allowedStatuses, true)) {
  $status = '';
}

$where = [];
$params = [];

if ($q !== '') {
  // recherche sur facture, note, fournisseur
  $where[] = "(pu.invoice_no LIKE ? OR pu.note LIKE ? OR s.name LIKE ?)";
  $params[] = "%$q%";
  $params[] = "%$q%";
  $params[] = "%$q%";
}

if ($project_id > 0) {
  $where[] = "pu.project_id = ?";
  $params[] = $project_id;
}

if ($supplier_id > 0) {
  $where[] = "pu.supplier_id = ?";
  $params[] = $supplier_id;
}

if ($status !== '') {
  $where[] = "pu.status = ?";
  $params[] = $status;
}

$sql = "
SELECT
  pu.id,
  pu.supplier_id,
  pu.project_id,
  pu.invoice_no,
  pu.invoice_date,
  pu.total_ht,
  pu.total_ttc,
  pu.status,
  pu.note,
  pu.created_at,
  s.name AS supplier_name,
  p.name AS project_name
FROM purchases pu
LEFT JOIN suppliers s ON s.id = pu.supplier_id
LEFT JOIN projects  p ON p.id = pu.project_id
" . ($where ? " WHERE " . implode(" AND ", $where) : "") . "
ORDER BY pu.id DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$purchases = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Filtres dropdown
$projects  = $pdo->query("SELECT id, name FROM projects ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$suppliers = $pdo->query("SELECT id, name FROM suppliers ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

// Message succès
$created = isset($_GET['created']) && $_GET['created'] === '1';

function statusLabel(string $st): string {
  return match ($st) {
    'DRAFT' => 'Brouillon',
    'VALIDATED' => 'Validé',
    'PARTIAL_PAID' => 'Partiellement payé',
    'PAID' => 'Payé',
    default => $st
  };
}
function statusBadge(string $st): string {
  return match ($st) {
    'PAID' => 'success',
    'PARTIAL_PAID' => 'warning',
    'VALIDATED' => 'info',
    'DRAFT' => 'secondary',
    default => 'secondary'
  };
}

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
  <div class="container-fluid">

    <div class="d-flex justify-content-between align-items-center mb-3">
      <div>
        <h3 class="mb-0">Achats (Factures)</h3>
        <small class="text-muted">1 ligne = 1 facture d'achat</small>
      </div>
      <a href="<?= e(base_url('/public/purchases/create.php')) ?>" class="btn btn-success">
        <i class="fas fa-plus mr-1"></i> Nouvel achat
      </a>
    </div>

    <?php if ($created): ?>
      <div class="alert alert-success">
        Achat enregistré avec succès.
      </div>
    <?php endif; ?>

    <div class="card mb-3">
      <div class="card-body">
        <form method="get" class="row">
          <div class="col-md-4 mb-2">
            <input class="form-control" name="q" value="<?= e($q) ?>" placeholder="Recherche (facture, note, fournisseur)">
          </div>

          <div class="col-md-3 mb-2">
            <select class="form-control" name="project_id">
              <option value="0">— Projet —</option>
              <?php foreach ($projects as $p): ?>
                <option value="<?= (int)$p['id'] ?>" <?= $project_id === (int)$p['id'] ? 'selected' : '' ?>>
                  <?= e($p['name']) ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-md-3 mb-2">
            <select class="form-control" name="supplier_id">
              <option value="0">— Fournisseur —</option>
              <?php foreach ($suppliers as $s): ?>
                <option value="<?= (int)$s['id'] ?>" <?= $supplier_id === (int)$s['id'] ? 'selected' : '' ?>>
                  <?= e($s['name']) ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-md-2 mb-2">
            <select class="form-control" name="status">
              <option value="">— Statut —</option>
              <?php foreach (['DRAFT','VALIDATED','PARTIAL_PAID','PAID'] as $st): ?>
                <option value="<?= $st ?>" <?= $status === $st ? 'selected' : '' ?>>
                  <?= e(statusLabel($st)) ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-12 d-flex justify-content-end">
            <button class="btn btn-primary mr-2"><i class="fas fa-filter mr-1"></i> Filtrer</button>
            <a class="btn btn-outline-secondary" href="<?= e(base_url('/public/purchases/index.php')) ?>">
              Réinitialiser
            </a>
          </div>
        </form>
      </div>
    </div>

    <div class="card">
      <div class="card-body table-responsive p-0">
        <table class="table table-hover mb-0">
          <thead>
            <tr>
              <th>#</th>
              <th>Date facture</th>
              <th>Projet</th>
              <th>Fournisseur</th>
              <th>N° facture</th>
              <th class="text-right">Total HT</th>
              <th class="text-right">Total TTC</th>
              <th>Statut</th>
              <th style="width:160px;">Actions</th>
            </tr>
          </thead>

          <tbody>
          <?php if (!$purchases): ?>
            <tr>
              <td colspan="9" class="text-center text-muted p-4">Aucun achat.</td>
            </tr>
          <?php else: ?>
            <?php foreach ($purchases as $pu): ?>
              <tr>
                <td><?= (int)$pu['id'] ?></td>
                <td><?= e($pu['invoice_date'] ?: ($pu['created_at'] ?? '')) ?></td>
                <td><?= e($pu['project_name'] ?? '-') ?></td>
                <td><?= e($pu['supplier_name'] ?? '-') ?></td>
                <td><?= e($pu['invoice_no'] ?? '-') ?></td>
                <td class="text-right"><?= number_format((float)($pu['total_ht'] ?? 0), 2, ',', ' ') ?></td>
                <td class="text-right"><strong><?= number_format((float)($pu['total_ttc'] ?? 0), 2, ',', ' ') ?></strong></td>
                <td>
                  <?php $b = statusBadge((string)($pu['status'] ?? '')); ?>
                  <span class="badge badge-<?= e($b) ?>"><?= e(statusLabel((string)($pu['status'] ?? ''))) ?></span>
                </td>
                <td>
                  <a class="btn btn-sm btn-info"
                     href="<?= e(base_url('/public/purchases/show.php?id=' . (int)$pu['id'])) ?>"
                     title="Voir">
                    <i class="fas fa-eye"></i>
                  </a>

                  <!-- Active si tu as edit.php -->
                  <a class="btn btn-sm btn-warning"
                     href="<?= e(base_url('/public/purchases/edit.php?id=' . (int)$pu['id'])) ?>"
                     title="Modifier">
                    <i class="fas fa-edit"></i>
                  </a>

                  <!-- Active si tu as delete.php -->
                  <a class="btn btn-sm btn-danger"
                     onclick="return confirm('Supprimer cet achat ?');"
                     href="<?= e(base_url('/public/purchases/delete.php?id=' . (int)$pu['id'])) ?>"
                     title="Supprimer">
                    <i class="fas fa-trash"></i>
                  </a>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
          </tbody>

        </table>
      </div>
    </div>

  </div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
