<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','finance']);

$active = 'purchases';
$subactive = 'purchases_list';

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
  header("Location: " . e(base_url('/public/purchases/index.php')));
  exit;
}

/* =========================
   Helpers
========================= */
function post($k, $d=null){ return $_POST[$k] ?? $d; }

/* =========================
   Charger achat
========================= */
$stmt = $pdo->prepare("
  SELECT pu.*, s.name AS supplier_name
  FROM purchases pu
  LEFT JOIN suppliers s ON s.id = pu.supplier_id
  WHERE pu.id = ?
");
$stmt->execute([$id]);
$purchase = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$purchase) {
  header("Location: " . e(base_url('/public/purchases/index.php')));
  exit;
}

/* =========================
   Paiements (pour warning)
========================= */
$stmt = $pdo->prepare("SELECT COALESCE(SUM(amount),0) FROM purchase_payments WHERE purchase_id=?");
$stmt->execute([$id]);
$paid_total = (float)$stmt->fetchColumn();

/* =========================
   Charger lignes
========================= */
$stmt = $pdo->prepare("SELECT * FROM purchase_lines WHERE purchase_id=? ORDER BY id ASC");
$stmt->execute([$id]);
$lines = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* =========================
   Listes
========================= */
$suppliers = $pdo->query("SELECT id, name FROM suppliers ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$projects  = $pdo->query("SELECT id, name FROM projects ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

$errors = [];

/* =========================
   POST
========================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

  $supplier_id  = (int)post('supplier_id', 0);
  $project_id   = post('project_id') !== '' ? (int)post('project_id') : null;
  $invoice_no   = trim((string)post('invoice_no'));
  $invoice_date = post('invoice_date') ?: null;
  $status       = post('status', 'DRAFT');
  $note         = trim((string)post('note'));

  $desc  = post('description', []);
  $qtys  = post('qty', []);
  $price = post('unit_price', []);

  if ($supplier_id <= 0) $errors[] = "Fournisseur obligatoire.";

  $newLines = [];
  $total_ht = 0;

  for ($i=0; $i<count($desc); $i++) {
    $d = trim((string)$desc[$i]);
    $q = (float)str_replace(',', '.', (string)($qtys[$i] ?? 0));
    $u = (float)str_replace(',', '.', (string)($price[$i] ?? 0));

    if ($d==='' && $q==0 && $u==0) continue;
    if ($d==='') { $errors[]="Ligne ".($i+1)." : description vide."; continue; }
    if ($q<=0) { $errors[]="Ligne ".($i+1)." : quantité invalide."; continue; }

    $t = round($q*$u, 2);
    $total_ht += $t;

    $newLines[] = compact('d','q','u','t');
  }

  if (!$newLines) $errors[] = "Au moins une ligne valide est requise.";

  $total_ht  = round($total_ht, 2);
  $total_ttc = $total_ht;

  // statut cohérent avec paiements
  if ($paid_total >= $total_ttc && $total_ttc > 0) $status = 'PAID';
  elseif ($paid_total > 0) $status = 'PARTIAL_PAID';
  elseif (!in_array($status, ['DRAFT','VALIDATED'], true)) $status = 'VALIDATED';

  if (!$errors) {
    try {
      $pdo->beginTransaction();

      // update purchase
      $stmt = $pdo->prepare("
        UPDATE purchases
        SET supplier_id=?, project_id=?, invoice_no=?, invoice_date=?,
            total_ht=?, total_ttc=?, status=?, note=?
        WHERE id=?
      ");
      $stmt->execute([
        $supplier_id,
        $project_id,
        $invoice_no ?: null,
        $invoice_date,
        $total_ht,
        $total_ttc,
        $status,
        $note ?: null,
        $id
      ]);

require_once __DIR__ . '/../../app/core/Stock.php';

if ($status === 'VALIDATED') {
  Stock::postPurchaseToStock($pdo, $id);
}


      // reset lignes
      $pdo->prepare("DELETE FROM purchase_lines WHERE purchase_id=?")->execute([$id]);

      $stmtLine = $pdo->prepare("
        INSERT INTO purchase_lines (purchase_id, description, qty, unit_price, total)
        VALUES (?,?,?,?,?)
      ");

      foreach ($newLines as $ln) {
        $stmtLine->execute([$id, $ln['d'], $ln['q'], $ln['u'], $ln['t']]);
      }

      $pdo->commit();
      header("Location: " . e(base_url('/public/purchases/show.php?id='.$id)));
      exit;

    } catch (Exception $e) {
      if ($pdo->inTransaction()) $pdo->rollBack();
      $errors[] = "Erreur : ".$e->getMessage();
    }
  }
}

/* =========================
   Valeurs form
========================= */
$old_supplier = $purchase['supplier_id'];
$old_project  = $purchase['project_id'];
$old_invoice  = $purchase['invoice_no'];
$old_date     = $purchase['invoice_date'];
$old_status   = $purchase['status'];
$old_note     = $purchase['note'];

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="d-flex justify-content-between mb-3">
  <h3>Modifier achat #<?= (int)$id ?></h3>
  <a class="btn btn-secondary" href="<?= e(base_url('/public/purchases/show.php?id='.$id)) ?>">
    ← Retour
  </a>
</div>

<?php if ($paid_total > 0): ?>
<div class="alert alert-warning">
  ⚠️ Des paiements existent (<?= number_format($paid_total,2,',',' ') ?>).  
  Le statut et les totaux seront recalculés automatiquement.
</div>
<?php endif; ?>

<?php if ($errors): ?>
<div class="alert alert-danger"><ul class="mb-0">
<?php foreach ($errors as $e): ?><li><?= e($e) ?></li><?php endforeach; ?>
</ul></div>
<?php endif; ?>

<form method="post">

<div class="row">
  <div class="col-md-4">
    <label>Fournisseur</label>
    <select class="form-control" name="supplier_id" required>
      <?php foreach ($suppliers as $s): ?>
        <option value="<?= $s['id'] ?>" <?= $old_supplier==$s['id']?'selected':'' ?>>
          <?= e($s['name']) ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-4">
    <label>Projet</label>
    <select class="form-control" name="project_id">
      <option value="">— Aucun —</option>
      <?php foreach ($projects as $p): ?>
        <option value="<?= $p['id'] ?>" <?= (string)$old_project===(string)$p['id']?'selected':'' ?>>
          <?= e($p['name']) ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-2">
    <label>Date facture</label>
    <input type="date" class="form-control" name="invoice_date" value="<?= e($old_date) ?>">
  </div>

  <div class="col-md-2">
    <label>N° facture</label>
    <input class="form-control" name="invoice_no" value="<?= e($old_invoice) ?>">
  </div>
</div>

<div class="mt-2">
  <label>Note</label>
  <textarea class="form-control" name="note"><?= e($old_note) ?></textarea>
</div>

<hr>

<h5>Lignes d’achat</h5>
<table class="table table-bordered">
<thead>
<tr><th>Description</th><th>Qté</th><th>PU</th><th>Total</th></tr>
</thead>
<tbody id="lines">
<?php foreach ($lines as $ln): ?>
<tr>
<td><input class="form-control" name="description[]" value="<?= e($ln['description']) ?>"></td>
<td><input class="form-control qty" name="qty[]" type="number" step="0.01" value="<?= e($ln['qty']) ?>"></td>
<td><input class="form-control unit" name="unit_price[]" type="number" step="0.01" value="<?= e($ln['unit_price']) ?>"></td>
<td class="lineTotal"><?= number_format($ln['total'],2,'.','') ?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>

<button class="btn btn-success">Enregistrer</button>

</form>
</div>
</section>

<script>
function recalc(){
 let t=0;
 document.querySelectorAll("#lines tr").forEach(r=>{
  let q=parseFloat(r.querySelector(".qty")?.value||0);
  let u=parseFloat(r.querySelector(".unit")?.value||0);
  let lt=Math.round(q*u*100)/100;
  r.querySelector(".lineTotal").textContent=lt.toFixed(2);
  t+=lt;
 });
}
document.addEventListener("input",e=>{
 if(e.target.classList.contains("qty")||e.target.classList.contains("unit")) recalc();
});
recalc();
</script>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
