<?php
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Auth.php';

Auth::requireLogin();

$prospects = $pdo->query("
    SELECT * FROM prospects
    ORDER BY created_at DESC
")->fetchAll();
?>

<h2>Prospects</h2>

<a href="create.php">➕ Nouveau prospect</a>

<table border="1" cellpadding="8" cellspacing="0">
    <tr>
        <th>Nom</th>
        <th>Téléphone</th>
        <th>Source</th>
        <th>Statut</th>
        <th>Date</th>
    <th>Action</th>
        
    </tr>

    <?php foreach ($prospects as $p): ?>
    <tr>
        <td><?= htmlspecialchars($p['fullname']) ?></td>
        <td><?= htmlspecialchars($p['phone']) ?></td>
        <td><?= $p['source'] ?></td>
<td>
    <form method="POST" action="update_status.php">
        <input type="hidden" name="id" value="<?= $p['id'] ?>">

        <select name="status" onchange="this.form.submit()">
            <option value="nouveau" <?= $p['status']=='nouveau'?'selected':'' ?>>Nouveau</option>
            <option value="contacte" <?= $p['status']=='contacte'?'selected':'' ?>>Contacté</option>
            <option value="interesse" <?= $p['status']=='interesse'?'selected':'' ?>>Intéressé</option>
            <option value="perdu" <?= $p['status']=='perdu'?'selected':'' ?>>Perdu</option>
            <option value="converti" <?= $p['status']=='converti'?'selected':'' ?>>Converti</option>
        </select>
    </form>
</td>
        <td><?= date('d/m/Y', strtotime($p['created_at'])) ?></td>
        <td>
    <?php if ($p['status'] !== 'converti'): ?>
        <a href="convert.php?id=<?= $p['id'] ?>"
           onclick="return confirm('Convertir ce prospect en client ?')">
           🔁 Convertir
        </a>
    <?php else: ?>
        ✅ Client
    <?php endif; ?>
</td>

    </tr>
    <?php endforeach; ?>
</table>
