<?php
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Auth.php';

Auth::requireLogin();

$prospect_id = (int)($_GET['id'] ?? 0);
if ($prospect_id <= 0) {
    header("Location: index.php");
    exit;
}

/* 1) Récupérer le prospect */
$stmt = $pdo->prepare("SELECT * FROM prospects WHERE id = ?");
$stmt->execute([$prospect_id]);
$prospect = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$prospect) {
    die("Prospect introuvable");
}

if ($prospect['status'] === 'converti') {
    header("Location: index.php");
    exit;
}

/* 2) Créer le client */
$stmt = $pdo->prepare("
    INSERT INTO clients (fullname, phone, email, prospect_id, created_at)
    VALUES (?, ?, ?, ?, NOW())
");

$stmt->execute([
    $prospect['fullname'],
    $prospect['phone'],
    $prospect['email'],
    $prospect['id']
]);

/* 3) Mettre à jour le statut du prospect */
$stmt = $pdo->prepare("
    UPDATE prospects
    SET status = 'converti'
    WHERE id = ?
");
$stmt->execute([$prospect_id]);

header("Location: index.php");
exit;
