<?php
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    redirect('/public/projects/progress.php');
}

// Projet
$stmt = $pdo->prepare("SELECT * FROM projects WHERE id = ?");
$stmt->execute([$id]);
$project = $stmt->fetch();

if (!$project) {
    redirect('/public/projects/progress.php');
}

$title = "Mise à jour avancement | " . $project['name'];
$active = 'projects';
$subactive = 'projects_progress';

$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $progress = (int)($_POST['progress_percent'] ?? 0);
    $note     = trim($_POST['note'] ?? '');

    if ($progress < 0) $progress = 0;
    if ($progress > 100) $progress = 100;

    // Mise à jour projet
    $stmt = $pdo->prepare("
        UPDATE projects
        SET progress_percent = ?, progress_updated_at = NOW()
        WHERE id = ?
    ");
    $stmt->execute([$progress, $id]);

    // Historique
    $stmt = $pdo->prepare("
        INSERT INTO project_progress_history (project_id, progress_percent, note)
        VALUES (?, ?, ?)
    ");
    $stmt->execute([$id, $progress, $note]);

    $success = true;

    // Rafraîchir données
    $project['progress_percent'] = $progress;
}

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="card">
  <div class="card-header">
    <h3 class="card-title">Avancement — <?= e($project['name']) ?></h3>
  </div>

  <div class="card-body">

    <?php if ($success): ?>
      <div class="alert alert-success">✅ Avancement mis à jour.</div>
    <?php endif; ?>

    <form method="post">
      <div class="form-group">
        <label>Avancement (%)</label>
        <input type="range" class="custom-range"
               name="progress_percent"
               min="0" max="100"
               value="<?= (int)$project['progress_percent'] ?>"
               oninput="this.nextElementSibling.value = this.value">
        <output class="ml-2"><?= (int)$project['progress_percent'] ?></output> %
      </div>

      <div class="form-group">
        <label>Note / Commentaire</label>
        <textarea name="note" class="form-control" rows="2"
                  placeholder="Ex : Avancement gros œuvre bloc A"><?= e($_POST['note'] ?? '') ?></textarea>
      </div>

      <button class="btn btn-success">
        <i class="fas fa-save"></i> Enregistrer
      </button>
      <a href="<?= e(base_url('/public/projects/progress.php')) ?>" class="btn btn-secondary ml-2">
        Retour
      </a>
    </form>

  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
