<?php
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$title = "Avancement des projets | IMMOTECH";
$active = 'projects';
$subactive = 'projects_progress';

// Récupérer tous les projets
$stmt = $pdo->query("SELECT id, name, progress_percent, progress_updated_at FROM projects ORDER BY id DESC");
$projects = $stmt->fetchAll();

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="card">
  <div class="card-header">
    <h3 class="card-title">Avancement des projets</h3>
  </div>

  <div class="card-body table-responsive p-0">
    <table class="table table-hover text-nowrap">
      <thead>
        <tr>
          <th>Projet</th>
          <th>Avancement</th>
          <th>Dernière mise à jour</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach ($projects as $p): ?>
        <tr>
          <td><?= e($p['name']) ?></td>
          <td>
            <div class="progress">
              <div class="progress-bar bg-info"
                   style="width: <?= (int)$p['progress_percent'] ?>%">
                <?= (int)$p['progress_percent'] ?>%
              </div>
            </div>
          </td>
          <td><?= e($p['progress_updated_at']) ?></td>
          <td>
            <a href="<?= e(base_url('/public/projects/progress_edit.php?id=' . $p['id'])) ?>"
               class="btn btn-sm btn-primary">
              <i class="fas fa-pen"></i> Mettre à jour
            </a>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>

</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
