<?php
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$title = "Projets | IMMOTECH";
$active = 'projects';
$subactive = 'projects_list';

// Récupération projets
$stmt = $pdo->query("SELECT * FROM projects ORDER BY id DESC");
$projects = $stmt->fetchAll();

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
  <div class="container-fluid">

    <div class="d-flex justify-content-between align-items-center mb-3">
      <h3 class="mb-0">Liste des projets</h3>
      <a class="btn btn-primary" href="<?= e(base_url('/public/projects/create.php')) ?>">
        <i class="fas fa-plus mr-1"></i> Ajouter un projet
      </a>
    </div>

    <div class="card">
      <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap mb-0">
          <thead>
            <tr>
              <th>ID</th>
              <th>Nom</th>
              <th>Adresse</th>
              <th>Début</th>
              <th>Achèvement</th>
              <th>Blocs</th>
              <th>Étages</th>
              <th>Avancement</th>
              <th>MAJ avancement</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
          <?php if (!$projects): ?>
            <tr><td colspan="10" class="text-center text-muted p-4">Aucun projet pour le moment.</td></tr>
          <?php else: ?>
            <?php foreach ($projects as $p): ?>
              <tr>
                <td><?= (int)$p['id'] ?></td>
                <td><strong><?= e($p['name'] ?? '') ?></strong></td>
                <td><?= e($p['address'] ?? '') ?></td>
                <td><?= e($p['start_date'] ?? '') ?></td>
                <td><?= e($p['end_date'] ?? '') ?></td>
                <td><?= e($p['blocks_count'] ?? '') ?></td>
                <td><?= e($p['floors_count'] ?? '') ?></td>
                <td>
                  <span class="badge badge-info"><?= (int)($p['progress_percent'] ?? 0) ?>%</span>
                </td>
                <td><?= e($p['progress_updated_at'] ?? '') ?></td>
                    <td>
                      <a class="btn btn-sm btn-warning"
                         href="<?= e(base_url('/public/projects/edit.php?id=' . $p['id'])) ?>">
                        <i class="fas fa-edit"></i>
                      </a>
                    
                      <a class="btn btn-sm btn-danger"
                         onclick="return confirm('Supprimer ce projet ?');"
                         href="<?= e(base_url('/public/projects/delete.php?id=' . $p['id'])) ?>">
                        <i class="fas fa-trash"></i>
                      </a>
                    </td>

              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

  </div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
