<?php
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$title = "Modifier un projet | IMMOTECH";
$active = 'projects';
$subactive = 'projects_list';

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    redirect('/public/projects/index.php');
}

// Récupérer le projet
$stmt = $pdo->prepare("SELECT * FROM projects WHERE id = ?");
$stmt->execute([$id]);
$project = $stmt->fetch();

if (!$project) {
    redirect('/public/projects/index.php');
}

$errors = [];
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name       = trim($_POST['name'] ?? '');
    $address    = trim($_POST['address'] ?? '');
    $start_date = $_POST['start_date'] ?? null;
    $end_date   = $_POST['end_date'] ?? null;
    $blocks     = (int)($_POST['blocks_count'] ?? 0);
    $floors     = (int)($_POST['floors_count'] ?? 0);

    if ($name === '') {
        $errors[] = "Le nom du projet est obligatoire.";
    }

    if (!$errors) {
        $stmt = $pdo->prepare("
            UPDATE projects SET
              name = ?, address = ?, start_date = ?, end_date = ?,
              blocks_count = ?, floors_count = ?
            WHERE id = ?
        ");
        $stmt->execute([
            $name, $address, $start_date, $end_date,
            $blocks, $floors, $id
        ]);

        $success = true;
    }
}

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="card">
  <div class="card-header">
    <h3 class="card-title">Modifier le projet</h3>
  </div>
  <div class="card-body">

    <?php if ($success): ?>
      <div class="alert alert-success">✅ Projet mis à jour avec succès.</div>
    <?php endif; ?>

    <?php if ($errors): ?>
      <div class="alert alert-danger">
        <ul class="mb-0">
          <?php foreach ($errors as $e): ?><li><?= e($e) ?></li><?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>

    <form method="post">
      <div class="form-group">
        <label>Nom du projet *</label>
        <input type="text" name="name" class="form-control"
               value="<?= e($_POST['name'] ?? $project['name']) ?>" required>
      </div>

      <div class="form-group">
        <label>Adresse</label>
        <textarea name="address" class="form-control"><?= e($_POST['address'] ?? $project['address']) ?></textarea>
      </div>

      <div class="row">
        <div class="col-md-6">
          <label>Date début</label>
          <input type="date" name="start_date" class="form-control"
                 value="<?= e($_POST['start_date'] ?? $project['start_date']) ?>">
        </div>
        <div class="col-md-6">
          <label>Date achèvement</label>
          <input type="date" name="end_date" class="form-control"
                 value="<?= e($_POST['end_date'] ?? $project['end_date']) ?>">
        </div>
      </div>

      <div class="row mt-2">
        <div class="col-md-6">
          <label>Nombre de blocs</label>
          <input type="number" name="blocks_count" class="form-control"
                 value="<?= e($_POST['blocks_count'] ?? $project['blocks_count']) ?>">
        </div>
        <div class="col-md-6">
          <label>Nombre d’étages</label>
          <input type="number" name="floors_count" class="form-control"
                 value="<?= e($_POST['floors_count'] ?? $project['floors_count']) ?>">
        </div>
      </div>

      <div class="mt-4">
        <button class="btn btn-success">
          <i class="fas fa-save"></i> Enregistrer
        </button>
        <a href="<?= e(base_url('/public/projects/index.php')) ?>" class="btn btn-secondary ml-2">
          Retour
        </a>
      </div>
    </form>

  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
