<?php
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$title = "Ajouter un projet | IMMOTECH";
$active = 'projects';
$subactive = 'projects_create';

$errors = [];
$success = false;

// Traitement formulaire
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name        = trim($_POST['name'] ?? '');
    $address     = trim($_POST['address'] ?? '');
    $start_date  = $_POST['start_date'] ?? null;
    $end_date    = $_POST['end_date'] ?? null;
    $blocks      = (int)($_POST['blocks_count'] ?? 0);
    $floors      = (int)($_POST['floors_count'] ?? 0);

    if ($name === '') {
        $errors[] = "Le nom du projet est obligatoire.";
    }

    if (!$errors) {
        $stmt = $pdo->prepare("
            INSERT INTO projects
            (name, address, start_date, end_date, blocks_count, floors_count, progress_percent, progress_updated_at)
            VALUES (?, ?, ?, ?, ?, ?, 0, NOW())
        ");
        $stmt->execute([
            $name,
            $address,
            $start_date,
            $end_date,
            $blocks,
            $floors
        ]);

        $success = true;
    }
}

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
  <div class="container-fluid">

    <div class="card">
      <div class="card-header">
        <h3 class="card-title">Ajouter un projet immobilier</h3>
      </div>

      <div class="card-body">

        <?php if ($success): ?>
          <div class="alert alert-success">
            ✅ Projet ajouté avec succès.
            <a href="<?= e(base_url('/public/projects/index.php')) ?>" class="alert-link ml-2">
              Retour à la liste
            </a>
          </div>
        <?php endif; ?>

        <?php if ($errors): ?>
          <div class="alert alert-danger">
            <ul class="mb-0">
              <?php foreach ($errors as $e): ?>
                <li><?= e($e) ?></li>
              <?php endforeach; ?>
            </ul>
          </div>
        <?php endif; ?>

        <form method="post">

          <div class="form-group">
            <label>Nom du projet *</label>
            <input type="text" name="name" class="form-control" required
                   value="<?= e($_POST['name'] ?? '') ?>">
          </div>

          <div class="form-group">
            <label>Adresse du projet</label>
            <textarea name="address" class="form-control" rows="2"><?= e($_POST['address'] ?? '') ?></textarea>
          </div>

          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label>Date de début</label>
                <input type="date" name="start_date" class="form-control"
                       value="<?= e($_POST['start_date'] ?? '') ?>">
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label>Date d’achèvement</label>
                <input type="date" name="end_date" class="form-control"
                       value="<?= e($_POST['end_date'] ?? '') ?>">
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label>Nombre de blocs</label>
                <input type="number" name="blocks_count" class="form-control" min="0"
                       value="<?= e($_POST['blocks_count'] ?? 0) ?>">
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label>Nombre d’étages</label>
                <input type="number" name="floors_count" class="form-control" min="0"
                       value="<?= e($_POST['floors_count'] ?? 0) ?>">
              </div>
            </div>
          </div>

          <div class="mt-4">
            <button type="submit" class="btn btn-success">
              <i class="fas fa-save mr-1"></i> Enregistrer
            </button>
            <a href="<?= e(base_url('/public/projects/index.php')) ?>" class="btn btn-secondary ml-2">
              Annuler
            </a>
          </div>

        </form>

      </div>
    </div>

  </div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
