<?php
/******************** DEBUG ********************/
ini_set('display_errors', 1);
error_reporting(E_ALL);

/******************** INCLUDES ********************/
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

/******************** VALIDATION ID ********************/
$payment_id = (int)($_GET['id'] ?? 0);
if ($payment_id <= 0) {
    die("Paiement invalide");
}

/******************** RÉCUPÉRATION DU PAIEMENT ********************/
$stmt = $pdo->prepare("
SELECT
    p.id,
    p.amount,
    p.method,
    p.reference,
    p.payment_date,
    p.status,

    po.id AS ov_id,
    po.amount AS ov_amount,

    c.fullname AS client_name,
    c.phone AS client_phone,

    l.reference AS lot_reference

FROM payments p
JOIN payment_orders po ON po.id = p.payment_order_id
JOIN clients c ON c.id = po.client_id
JOIN lots l ON l.id = po.lot_id

WHERE p.id = ?
");
$stmt->execute([$payment_id]);
$payment = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$payment) {
    die("Paiement introuvable");
}

$title = "Reçu de paiement #".$payment['id'];
$active = 'payments';
$subactive = 'payments';
?>

<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="utf-8">
<title><?= e($title) ?></title>

<style>
body {
    font-family: Arial, sans-serif;
    background: #fff;
}
.container {
    width: 700px;
    margin: auto;
    border: 1px solid #ddd;
    padding: 25px;
}
h1 {
    text-align: center;
    margin-bottom: 30px;
}
hr {
    margin: 20px 0;
}
.label {
    font-weight: bold;
}
.footer {
    margin-top: 40px;
    text-align: center;
    font-size: 13px;
    color: #555;
}
@media print {
    .no-print { display: none; }
}
</style>
</head>

<body>

<div class="container">

<h1>Reçu de paiement</h1>

<p>
    <span class="label">N° Reçu :</span> <?= (int)$payment['id'] ?><br>
    <span class="label">Date :</span>
    <?= date('d/m/Y H:i', strtotime($payment['payment_date'])) ?><br>
    <span class="label">Statut :</span> <?= e($payment['status']) ?>
</p>

<hr>

<h3>Client</h3>
<p>
    <?= e($payment['client_name']) ?><br>
    Tél : <?= e($payment['client_phone']) ?>
</p>

<hr>

<h3>Détails du bien</h3>
<p>
    <span class="label">Lot :</span> <?= e($payment['lot_reference']) ?><br>
    <span class="label">Ordre de versement :</span> #<?= (int)$payment['ov_id'] ?>
</p>

<hr>

<h3>Détails du paiement</h3>
<p>
    <span class="label">Montant payé :</span>
    <strong><?= number_format($payment['amount'], 2, ',', ' ') ?> DA</strong><br>
    <span class="label">Mode :</span> <?= ucfirst($payment['method']) ?><br>
    <?php if ($payment['reference']): ?>
        <span class="label">Référence :</span> <?= e($payment['reference']) ?><br>
    <?php endif; ?>
</p>

<hr>

<p>
    <em>
        Ce reçu atteste que le paiement ci-dessus a été effectué
        conformément aux conditions de l’ordre de versement.
    </em>
</p>

<div class="footer">
    <p>Signature & cachet</p>
    <br><br>
    ___________________________
</div>

<div class="no-print" style="margin-top:30px;text-align:center;">
    <button onclick="window.print()" class="btn btn-primary">
        🖨️ Imprimer
    </button>
</div>

</div>

</body>
</html>
