<?php
require_once __DIR__.'/../../app/core/Auth.php';
require_once __DIR__.'/../../app/config/database.php';
require_once __DIR__.'/../../app/core/helpers.php';

Auth::requireLogin();

$title  = "Paiements";
$active = 'payments';

$payments = $pdo->query("
SELECT
    p.id,
    c.fullname AS client,
    l.reference AS lot,
    p.amount,
    p.method,
    p.payment_date
FROM payments p
JOIN payment_orders po ON po.id = p.payment_order_id
JOIN clients c ON c.id = po.client_id
JOIN lots l ON l.id = po.lot_id
ORDER BY p.payment_date DESC
")->fetchAll(PDO::FETCH_ASSOC);

include __DIR__.'/../../app/views/layout/header.php';
include __DIR__.'/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">



<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Liste des paiements</h3>


<a href="<?= e(base_url('/public/payments/create.php')) ?>" class="btn btn-success">
  <i class="fas fa-plus"></i> Ajouter un paiement
</a>
</div>

<div class="card">
<div class="card-header">
    <h3 class="card-title">Liste des paiements</h3>
</div>


<div class="card-body table-responsive p-0">
<table class="table table-hover mb-0">
<thead>
<tr>
    <th>#</th>
    <th>Client</th>
    <th>Lot</th>
    <th>Montant</th>
    <th>Méthode</th>
    <th>Date</th>
</tr>
</thead>
<tbody>
<?php foreach ($payments as $p): ?>
<tr>
    <td><?= $p['id'] ?></td>
    <td><?= e($p['client']) ?></td>
    <td><?= e($p['lot']) ?></td>
    <td><?= number_format($p['amount'], 0, ' ', ' ') ?> DA</td>
    <td><?= e($p['method']) ?></td>
    <td><?= e($p['payment_date']) ?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
</div>
</div>

</div>
</section>

<?php include __DIR__.'/../../app/views/layout/footer.php'; ?>
