<?php
/******************** DEBUG ********************/
ini_set('display_errors', 1);
error_reporting(E_ALL);

/******************** INCLUDES ********************/
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$title  = "Paiements";
$active = 'payments';
$subactive = 'payments';

/******************** RÉCUPÉRATION DES PAIEMENTS ********************/
$sql = "
SELECT
    p.id,
    p.amount,
    p.method,
    p.reference,
    p.payment_date,
    p.status,

    po.id AS ov_id,
    po.amount AS ov_amount,

    c.fullname AS client_name,
    l.reference AS lot_reference

FROM payments p
JOIN payment_orders po ON po.id = p.payment_order_id
JOIN clients c ON c.id = po.client_id
JOIN lots l ON l.id = po.lot_id

ORDER BY p.payment_date DESC
";

$stmt = $pdo->query($sql);
$payments = $stmt->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="card">
<div class="card-header">
    <h3 class="card-title">Journal des paiements</h3>
</div>

<div class="card-body p-0">

<table class="table table-bordered table-hover mb-0">
<thead class="thead-light">
<tr>
    <th>#</th>
    <th>Date</th>
    <th>Client</th>
    <th>Lot</th>
    <th>OV</th>
    <th>Montant (DA)</th>
    <th>Méthode</th>
    <th>Statut</th>
    <th>Actions</th>
</tr>
</thead>
<tbody>

<?php if (!$payments): ?>
<tr>
    <td colspan="9" class="text-center text-muted">
        Aucun paiement enregistré
    </td>
</tr>
<?php endif; ?>

<?php foreach ($payments as $row): ?>
<tr>
    <td><?= (int)$row['id'] ?></td>
    <td><?= date('d/m/Y H:i', strtotime($row['payment_date'])) ?></td>
    <td><?= e($row['client_name']) ?></td>
    <td><?= e($row['lot_reference']) ?></td>
    <td>#<?= (int)$row['ov_id'] ?></td>
    <td><?= number_format($row['amount'], 2, ',', ' ') ?></td>
    <td><?= ucfirst($row['method']) ?></td>

    <td>
        <span class="badge badge-<?= $row['status'] === 'valide' ? 'success' : 'secondary' ?>">
            <?= e($row['status']) ?>
        </span>
    </td>

    <td>
        <a href="../../public/payment_orders/show.php?id=<?= $row['ov_id'] ?>"
           class="btn btn-info btn-sm">
           Voir OV
        </a>
        <a href="../../public/payments/receipt.php?id=<?= $row['id'] ?>"
   class="btn btn-secondary btn-sm">
   Reçu
</a>

    </td>
</tr>
<?php endforeach; ?>

</tbody>
</table>

</div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
