<?php
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$reservation_id = (int)($_GET['reservation_id'] ?? 0);
if ($reservation_id <= 0) {
    redirect('/public/payments/index.php');
}

/**
 * Infos dossier
 */
$stmt = $pdo->prepare("
SELECT
  r.client_name,
  l.reference AS lot_reference,
  s.final_price
FROM reservations r
JOIN lots l ON l.id = r.lot_id
JOIN simulations s ON s.id = r.simulation_id
WHERE r.id = ?
");
$stmt->execute([$reservation_id]);
$info = $stmt->fetch();

if (!$info) {
    redirect('/public/payments/index.php');
}

/**
 * Historique paiements (⚠️ AVEC ID)
 */
$stmt = $pdo->prepare("
SELECT
  id,
  amount,
  payment_date,
  method
FROM payments
WHERE reservation_id = ?
ORDER BY payment_date DESC, id DESC
");
$stmt->execute([$reservation_id]);
$payments = $stmt->fetchAll();

$title  = "Historique des paiements";
$active = 'payments';

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<h3 class="mb-3">🧾 Historique des paiements</h3>

<a href="<?= e(base_url('/public/payments/export_pdf.php?reservation_id='.$reservation_id)) ?>"
   class="btn btn-danger mb-3">
   📄 Export PDF
</a>

<div class="card mb-3">
  <div class="card-body">
    <strong>Lot :</strong> <?= e($info['lot_reference']) ?><br>
    <strong>Client :</strong> <?= e($info['client_name']) ?><br>
    <strong>Prix total :</strong> <?= number_format($info['final_price'], 0, ' ', ' ') ?> DA
  </div>
</div>

<div class="card">
<div class="card-body table-responsive p-0">

<table class="table table-bordered">
<thead>
<tr>
  <th>Date</th>
  <th>Montant</th>
  <th>Mode</th>
  <th>Action</th>
</tr>
</thead>

<tbody>
<?php if (!$payments): ?>
<tr>
  <td colspan="4" class="text-center text-muted p-4">
    Aucun paiement enregistré.
  </td>
</tr>
<?php else: foreach ($payments as $p): ?>
<tr>
  <td><?= date('d/m/Y', strtotime($p['payment_date'])) ?></td>
  <td><?= number_format($p['amount'], 0, ' ', ' ') ?> DA</td>
  <td><?= e(ucfirst($p['method'])) ?></td>
  <td>
    <a href="<?= e(base_url('/public/payments/receipt.php?id='.$p['id'])) ?>"
       class="btn btn-sm btn-outline-primary">
       🧾 Reçu
    </a>
  </td>
</tr>
<?php endforeach; endif; ?>
</tbody>
</table>

</div>
</div>

<a href="<?= e(base_url('/public/payments/index.php')) ?>"
   class="btn btn-secondary mt-3">
   ← Retour à la gestion des paiements
</a>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>