<?php
ini_set('display_errors', 0);
error_reporting(0);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';
require_once __DIR__ . '/../../app/libs/fpdf/fpdf.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','finance']);

$payment_id = (int)($_GET['id'] ?? 0);
if ($payment_id <= 0) {
    die('ID paiement invalide');
}

/*
  payments → reservation_id
  reservations → client_name / client_phone
*/
$stmt = $pdo->prepare("
    SELECT
      p.id,
      p.amount,
      p.method,
      p.created_at,
      p.reservation_id,
      r.client_name,
      r.client_phone
    FROM payments p
    JOIN reservations r ON r.id = p.reservation_id
    WHERE p.id = ?
");
$stmt->execute([$payment_id]);
$payment = $stmt->fetch();

if (!$payment) {
    die('Paiement introuvable');
}

/* =========================
   PDF
   ========================= */
$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetAutoPageBreak(true, 20);

/* Titre */
$pdf->SetFont('Arial', 'B', 16);
$pdf->Cell(0, 10, 'Recu de paiement', 0, 1, 'C');
$pdf->Ln(5);

/* Infos client */
$pdf->SetFont('Arial', '', 11);
$pdf->Cell(0, 8, 'Client : ' . $payment['client_name'], 0, 1);
$pdf->Cell(0, 8, 'Telephone : ' . ($payment['client_phone'] ?? '-'), 0, 1);
$pdf->Ln(3);

/* Infos paiement */
$pdf->Cell(0, 8, 'Numero paiement : #' . $payment['id'], 0, 1);
$pdf->Cell(0, 8, 'Numero reservation : #' . $payment['reservation_id'], 0, 1);
$pdf->Cell(0, 8, 'Date : ' . $payment['created_at'], 0, 1);
$pdf->Ln(3);

/* Montant */
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, 'Montant paye : ' . number_format((float)$payment['amount'], 0, ' ', ' ') . ' DA', 0, 1);
$pdf->Ln(3);

/* Methode */
$pdf->SetFont('Arial', '', 11);
$pdf->Cell(0, 8, 'Methode de paiement : ' . ($payment['method'] ?? '-'), 0, 1);

$pdf->Ln(15);

/* Signature */
$pdf->Cell(0, 8, 'Signature et cachet', 0, 1);
$pdf->Ln(15);
$pdf->Cell(0, 8, '_____________________________', 0, 1);

$pdf->Output('I', 'recu_paiement_'.$payment['id'].'.pdf');
exit;
