<?php
/******************** DEBUG ********************/
ini_set('display_errors', 1);
error_reporting(E_ALL);

/******************** INCLUDES ********************/
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$title  = "Encaisser un paiement";
$active = 'payments';

/******************** RÉCUPÉRATION OV ********************/
$ov_id = (int)($_GET['ov_id'] ?? 0);

if ($ov_id <= 0) {
    die("OV invalide");
}

$stmt = $pdo->prepare("
    SELECT
        po.*,
        c.fullname AS client_name,
        l.reference AS lot_reference
    FROM payment_orders po
    JOIN clients c ON c.id = po.client_id
    JOIN lots l ON l.id = po.lot_id
    WHERE po.id = ?
");
$stmt->execute([$ov_id]);
$ov = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$ov) {
    die("Ordre de versement introuvable");
}

/******************** TOTAL PAYÉ POUR CET OV ********************/
$stmt = $pdo->prepare("
    SELECT IFNULL(SUM(amount),0)
    FROM payments
    WHERE payment_order_id = ?
      AND status = 'valide'
");
$stmt->execute([$ov_id]);
$total_paid = (float)$stmt->fetchColumn();

$remaining = max(0, $ov['amount'] - $total_paid);

$errors = [];

/******************** POST : ENCAISSEMENT ********************/
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $amount    = (float)($_POST['amount'] ?? 0);
    $method    = $_POST['method'] ?? '';
    $reference = trim($_POST['reference'] ?? '');

    if ($amount <= 0) {
        $errors[] = "Montant invalide";
    }

    if ($amount > $remaining) {
        $errors[] = "Le montant dépasse le reste à payer de l’OV";
    }

    if (!$method) {
        $errors[] = "Mode de paiement requis";
    }

    if (!$errors) {

        /********************
         * 1️⃣ INSÉRER LE PAIEMENT
         ********************/
        $stmt = $pdo->prepare("
            INSERT INTO payments
            (payment_order_id, amount, payment_date, method, reference, status)
            VALUES (?, ?, NOW(), ?, ?, 'valide')
        ");
        $stmt->execute([
            $ov_id,
            $amount,
            $method,
            $reference ?: null
        ]);

        /********************
         * 2️⃣ PASSER LE CLIENT À CLIENT (DÈS 1ER PAIEMENT)
         ********************/
        $stmt = $pdo->prepare("
            UPDATE clients
            SET status = 'client'
            WHERE id = ?
              AND status = 'prospect'
        ");
        $stmt->execute([$ov['client_id']]);

        /********************
         * 3️⃣ RECALCULER TOTAL PAYÉ POUR CET OV
         ********************/
        $stmt = $pdo->prepare("
            SELECT IFNULL(SUM(amount),0)
            FROM payments
            WHERE payment_order_id = ?
              AND status = 'valide'
        ");
        $stmt->execute([$ov_id]);
        $total_paid = (float)$stmt->fetchColumn();

        /********************
         * 4️⃣ SI OV SOLDÉE → MARQUER OV PAYÉE
         ********************/
        if ($total_paid >= $ov['amount']) {
            $pdo->prepare("
                UPDATE payment_orders
                SET status = 'payee'
                WHERE id = ?
            ")->execute([$ov_id]);
        }

        /********************
         * 5️⃣ REDIRECTION
         ********************/
        redirect("/public/payment_orders/show.php?id=$ov_id");
        exit;
    }
}

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="card">
<div class="card-header">
    <h3 class="card-title">Encaisser un paiement</h3>
</div>

<div class="card-body">

<?php if ($errors): ?>
<div class="alert alert-danger">
<ul class="mb-0">
<?php foreach ($errors as $e): ?>
<li><?= e($e) ?></li>
<?php endforeach; ?>
</ul>
</div>
<?php endif; ?>

<!-- INFOS OV -->
<div class="mb-4">
    <strong>Client :</strong> <?= e($ov['client_name']) ?><br>
    <strong>Lot :</strong> <?= e($ov['lot_reference']) ?><br>
    <strong>Montant OV :</strong> <?= number_format($ov['amount'], 2, ',', ' ') ?> DA<br>
    <strong>Total payé :</strong> <?= number_format($total_paid, 2, ',', ' ') ?> DA<br>
    <strong>Reste à payer :</strong> <?= number_format($remaining, 2, ',', ' ') ?> DA<br>
    <strong>Statut OV :</strong> <?= e($ov['status']) ?>
</div>

<hr>

<!-- FORMULAIRE -->
<form method="post">

<div class="row">
<div class="col-md-4">
    <label>Montant à encaisser *</label>
    <input type="number" step="0.01" name="amount" class="form-control" required>
</div>

<div class="col-md-4">
    <label>Mode de paiement *</label>
    <select name="method" class="form-control" required>
        <option value="">-- Choisir --</option>
        <option value="especes">Espèces</option>
        <option value="cheque">Chèque</option>
        <option value="virement">Virement</option>
        <option value="carte">Carte</option>
    </select>
</div>

<div class="col-md-4">
    <label>Référence</label>
    <input type="text" name="reference" class="form-control">
</div>
</div>

<div class="mt-4">
<button class="btn btn-success">
    <i class="fas fa-cash-register"></i> Encaisser
</button>

<a href="/public/payment_orders/show.php?id=<?= $ov_id ?>" class="btn btn-secondary ml-2">
    Annuler
</a>
</div>

</form>

</div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
