<?php
/******************** DEBUG ********************/
ini_set('display_errors', 1);
error_reporting(E_ALL);

/******************** INCLUDES ********************/
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

/******************** PERMISSION (OPTIONNEL) ********************/
// if (!Auth::isAdmin()) {
//     die("Accès refusé");
// }

/******************** VALIDATION ********************/
$payment_id = (int)($_GET['id'] ?? 0);
if ($payment_id <= 0) {
    die("Paiement invalide");
}

/******************** RÉCUPÉRATION DU PAIEMENT ********************/
$stmt = $pdo->prepare("
SELECT
    p.*,
    po.id AS ov_id,
    po.amount AS ov_amount,
    po.lot_id
FROM payments p
JOIN payment_orders po ON po.id = p.payment_order_id
WHERE p.id = ?
");
$stmt->execute([$payment_id]);
$payment = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$payment) {
    die("Paiement introuvable");
}

if ($payment['status'] === 'annule') {
    die("Ce paiement est déjà annulé");
}

/******************** ANNULATION ********************/
$pdo->beginTransaction();

try {

    // 1️⃣ Annuler le paiement
    $pdo->prepare("
        UPDATE payments
        SET status = 'annule'
        WHERE id = ?
    ")->execute([$payment_id]);

    // 2️⃣ Recalcul total payé OV
    $stmt = $pdo->prepare("
        SELECT IFNULL(SUM(amount),0)
        FROM payments
        WHERE payment_order_id = ?
          AND status = 'valide'
    ");
    $stmt->execute([$payment['payment_order_id']]);
    $total_paid = (float)$stmt->fetchColumn();

    // 3️⃣ Mise à jour OV
    if ($total_paid < $payment['ov_amount']) {

        $pdo->prepare("
            UPDATE payment_orders
            SET status = 'en_attente'
            WHERE id = ?
        ")->execute([$payment['ov_id']]);

        // 4️⃣ Lot repasse réservé
        $pdo->prepare("
            UPDATE lots
            SET status = 'reserve'
            WHERE id = ?
        ")->execute([$payment['lot_id']]);
    }

    $pdo->commit();

} catch (Exception $e) {
    $pdo->rollBack();
    die("Erreur annulation : ".$e->getMessage());
}

redirect("/public/payment_orders/show.php?id=".$payment['ov_id']);
exit;
