<?php
require_once __DIR__.'/../../app/core/Auth.php';
require_once __DIR__.'/../../app/config/database.php';
require_once __DIR__.'/../../app/core/helpers.php';

Auth::requireLogin();

$ov_id = (int)($_GET['id'] ?? 0);
if ($ov_id <= 0) redirect('/public/payments/index.php');

$stmt = $pdo->prepare("
SELECT
    po.*,
    c.fullname AS client,
    l.reference AS lot
FROM payment_orders po
JOIN clients c ON c.id = po.client_id
JOIN lots l ON l.id = po.lot_id
WHERE po.id = ?
");
$stmt->execute([$ov_id]);
$ov = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$ov) redirect('/public/payments/index.php');

$title  = "Ordre de versement #".$ov_id;
$active = 'payments';

include __DIR__.'/../../app/views/layout/header.php';
include __DIR__.'/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="card">
<div class="card-header">
    <h3 class="card-title">Ordre de versement</h3>
</div>

<div class="card-body">
<p><strong>Client :</strong> <?= e($ov['client']) ?></p>
<p><strong>Lot :</strong> <?= e($ov['lot']) ?></p>
<p><strong>Montant :</strong> <?= number_format($ov['amount'], 0, ' ', ' ') ?> DA</p>
<p><strong>Statut :</strong> <?= e($ov['status']) ?></p>
<p><strong>Date :</strong> <?= e($ov['created_at']) ?></p>

<hr>

<?php if ($ov['status'] !== 'payee'): ?>
    <a href="<?= e(base_url('/public/payments/create.php?ov_id='.$ov['id'])) ?>"
       class="btn btn-success">
        <i class="fas fa-cash-register"></i> Encaisser
    </a>
<?php endif; ?>


<a href="/public/payments/index.php" class="btn btn-secondary">
    Retour
</a>
</div>
</div>

</div>
</section>

<?php include __DIR__.'/../../app/views/layout/footer.php'; ?>
