<?php
/******************** DEBUG ********************/
ini_set('display_errors', 1);
error_reporting(E_ALL);

/******************** INCLUDES ********************/
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$title  = "Reste à encaisser";
$active = 'payments';
$subactive = 'pending';

/******************** REQUÊTE PRINCIPALE ********************/
$sql = "
SELECT
    po.id AS ov_id,
    po.amount AS ov_amount,
    po.status AS ov_status,
    po.created_at,

    c.fullname AS client_name,
    l.reference AS lot_reference,

    IFNULL(SUM(p.amount),0) AS total_paid

FROM payment_orders po
JOIN clients c ON c.id = po.client_id
JOIN lots l ON l.id = po.lot_id
LEFT JOIN payments p 
    ON p.payment_order_id = po.id
   AND p.status = 'valide'

WHERE po.status != 'payee'

GROUP BY po.id
HAVING (po.amount - total_paid) > 0

ORDER BY po.created_at ASC
";

$stmt = $pdo->query($sql);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="card">
<div class="card-header">
    <h3 class="card-title">Tableau – Reste à encaisser</h3>
</div>

<div class="card-body p-0">

<table class="table table-bordered table-hover mb-0">
<thead class="thead-light">
<tr>
    <th>OV</th>
    <th>Client</th>
    <th>Lot</th>
    <th>Montant OV (DA)</th>
    <th>Total payé (DA)</th>
    <th>Reste à encaisser (DA)</th>
    <th>Statut</th>
    <th>Actions</th>
</tr>
</thead>
<tbody>

<?php if (!$rows): ?>
<tr>
    <td colspan="8" class="text-center text-muted">
        Aucun reste à encaisser
    </td>
</tr>
<?php endif; ?>

<?php foreach ($rows as $r): 
    $remaining = $r['ov_amount'] - $r['total_paid'];
?>
<tr>
    <td>#<?= (int)$r['ov_id'] ?></td>
    <td><?= e($r['client_name']) ?></td>
    <td><?= e($r['lot_reference']) ?></td>
    <td><?= number_format($r['ov_amount'], 2, ',', ' ') ?></td>
    <td><?= number_format($r['total_paid'], 2, ',', ' ') ?></td>
    <td>
        <strong class="text-danger">
            <?= number_format($remaining, 2, ',', ' ') ?>
        </strong>
    </td>
    <td>
        <span class="badge badge-warning">
            <?= e($r['ov_status']) ?>
        </span>
    </td>
    <td>
        <a href="../../public/payment_orders/show.php?id=<?= $r['ov_id'] ?>"
           class="btn btn-info btn-sm">
           Voir OV
        </a>

        <a href="../../public/payments/create.php?ov_id=<?= $r['ov_id'] ?>"
           class="btn btn-success btn-sm">
           Encaisser
        </a>
    </td>
</tr>
<?php endforeach; ?>

</tbody>
</table>

</div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
