<?php
/******************** INCLUDES ********************/
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$title = "Ordres de versement";
$active = 'payments';
$subactive = 'ov';

/******************** RÉCUPÉRATION DES OV ********************/
$sql = "
SELECT
    po.id,
    po.amount,
    po.due_date,
    po.status,
    po.created_at,

    c.fullname AS client_name,
    l.reference AS lot_reference
FROM payment_orders po
JOIN clients c ON c.id = po.client_id
JOIN lots l ON l.id = po.lot_id
ORDER BY po.created_at DESC
";

$stmt = $pdo->query($sql);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Liste des ordres de versement</h3>
    </div>

    <div class="card-body p-0">

        <table class="table table-bordered table-hover mb-0">
            <thead class="thead-light">
                <tr>
                    <th>#</th>
                    <th>Client</th>
                    <th>Lot</th>
                    <th>Montant (DA)</th>
                    <th>Date limite</th>
                    <th>Statut</th>
                    <th>Date création</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>

            <?php if (empty($orders)): ?>
                <tr>
                    <td colspan="8" class="text-center text-muted">
                        Aucun ordre de versement trouvé
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($orders as $row): ?>
                <tr>
                    <td><?= (int)$row['id'] ?></td>
                    <td><?= e($row['client_name']) ?></td>
                    <td><?= e($row['lot_reference']) ?></td>
                    <td><?= number_format($row['amount'], 2, ',', ' ') ?> DA</td>
                    <td><?= e($row['due_date']) ?></td>

                    <td>
                        <?php if ($row['status'] === 'en_attente'): ?>
                            <span class="badge badge-warning">En attente</span>
                        <?php elseif ($row['status'] === 'payee'): ?>
                            <span class="badge badge-success">Payée</span>
                        <?php else: ?>
                            <span class="badge badge-danger">Annulée</span>
                        <?php endif; ?>
                    </td>

                    <td><?= date('Y-m-d H:i', strtotime($row['created_at'])) ?></td>

                    <td>
                        <a href="show.php?id=<?= $row['id'] ?>">Voir</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>

            </tbody>
        </table>

    </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
