<?php
require_once __DIR__ . '/../../../app/core/Auth.php';
require_once __DIR__ . '/../../../app/config/database.php';
require_once __DIR__ . '/../../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial']);

$marketingStatuses = [
    'nouveau',
    'a_contacter',
    'contacte',
    'interesse',
    'non_interesse'
];

$id     = (int)($_POST['id'] ?? 0);
$status = $_POST['status'] ?? '';

if ($id <= 0 || !in_array($status, $marketingStatuses, true)) {
    header('Location: index.php');
    exit;
}

$stmt = $pdo->prepare("
    UPDATE marketing_prospects
    SET status = ?
    WHERE id = ?
");
$stmt->execute([$status, $id]);

header('Location: index.php');
exit;
