<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

/******************** INCLUDES ********************/
require_once __DIR__ . '/../../../app/core/helpers.php';
require_once __DIR__ . '/../../../app/core/Auth.php';
require_once __DIR__ . '/../../../app/config/database.php';
require_once __DIR__ . '/../../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','finance']);

$title  = "Prospect | Marketing";
$active = 'marketing';

/******************** RÉCUP ID ********************/
$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    redirect('/public/marketing/prospects/index.php');
}

/******************** PROSPECT ********************/
$stmt = $pdo->prepare("
    SELECT mp.*, u.name AS commercial_name
    FROM marketing_prospects mp
    LEFT JOIN users u ON u.id = mp.commercial_id
    WHERE mp.id = ?
");
$stmt->execute([$id]);
$prospect = $stmt->fetch();

if (!$prospect) {
    redirect('/public/marketing/prospects/index.php');
}

/******************** ACTIONS ********************/
$stmt = $pdo->prepare("
    SELECT ma.*, u.name AS user_name
    FROM marketing_actions ma
    JOIN users u ON u.id = ma.user_id
    WHERE ma.prospect_id = ?
    ORDER BY ma.action_date DESC
");
$stmt->execute([$id]);
$actions = $stmt->fetchAll();

/******************** LAYOUT ********************/
include __DIR__ . '/../../../app/views/layout/header.php';
include __DIR__ . '/../../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<!-- ================= HEADER ================= -->
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Détail du prospect</h3>
  <a class="btn btn-secondary"
     href="<?= e(base_url('/public/marketing/prospects/index.php')) ?>">
    <i class="fas fa-arrow-left"></i> Retour
  </a>
</div>

<!-- ================= INFOS PROSPECT ================= -->
<div class="card">
  <div class="card-body">

    <div class="row mb-3">
      <div class="col-md-6">
        <strong>Nom complet</strong><br>
        <?= e($prospect['fullname']) ?>
      </div>
      <div class="col-md-6">
        <strong>Statut</strong><br>
        <span class="badge badge-info">
          <?= ucfirst(str_replace('_',' ',$prospect['status'])) ?>
        </span>
      </div>
    </div>

    <hr>

    <div class="row mb-3">
      <div class="col-md-6">
        <strong>Téléphone</strong><br>
        <?= e($prospect['phone'] ?? '-') ?>
      </div>
      <div class="col-md-6">
        <strong>Email</strong><br>
        <?= e($prospect['email'] ?? '-') ?>
      </div>
    </div>

    <hr>

    <div class="row mb-3">
      <div class="col-md-6">
        <strong>Source</strong><br>
        <?= e($prospect['source'] ?? '-') ?>
      </div>
      <div class="col-md-6">
        <strong>Commercial assigné</strong><br>
        <?= e($prospect['commercial_name'] ?? '-') ?>
      </div>
    </div>

    <hr>

    <div class="row">
      <div class="col-md-12">
        <strong>Intérêt / Besoin</strong>
        <div class="border rounded p-2 mt-2 bg-light">
          <?= nl2br(e($prospect['interest'] ?? '')) ?>
        </div>
      </div>
    </div>

  </div>
</div>

<!-- ================= AJOUT ACTION ================= -->
<div class="card mt-4">
  <div class="card-header">
    <strong>Ajouter une action</strong>
  </div>

  <form method="POST"
        action="<?= e(base_url('/public/marketing/actions/store.php')) ?>">
    <div class="card-body">

      <input type="hidden" name="prospect_id"
             value="<?= (int)$prospect['id'] ?>">

      <div class="row">
        <div class="col-md-3 mb-3">
          <label>Type</label>
          <select class="form-control" name="type" required>
            <option value="appel">Appel</option>
            <option value="email">Email</option>
            <option value="tache">Tâche</option>
          </select>
        </div>

        <div class="col-md-3 mb-3">
          <label>Date</label>
          <input class="form-control"
                 type="datetime-local"
                 name="action_date"
                 required>
        </div>

        <div class="col-md-6 mb-3">
          <label>Note</label>
          <input class="form-control"
                 name="note"
                 placeholder="Compte rendu, rappel, résultat…">
        </div>
      </div>

    </div>

    <div class="card-footer text-right">
      <button class="btn btn-primary">
        <i class="fas fa-plus"></i> Ajouter
      </button>
    </div>
  </form>
</div>

<!-- ================= HISTORIQUE ACTIONS ================= -->
<div class="card mt-4">
  <div class="card-header">
    <strong>Historique des actions</strong>
  </div>

  <div class="card-body p-0">
    <table class="table table-sm table-hover mb-0">
      <thead>
        <tr>
          <th>Date</th>
          <th>Type</th>
          <th>Note</th>
          <th>Utilisateur</th>
        </tr>
      </thead>
      <tbody>

        <?php if (!$actions): ?>
          <tr>
            <td colspan="4" class="text-center text-muted p-3">
              Aucune action enregistrée
            </td>
          </tr>
        <?php else: foreach ($actions as $a): ?>
          <tr>
            <td><?= date('d/m/Y H:i', strtotime($a['action_date'])) ?></td>
            <td>
              <span class="badge badge-secondary">
                <?= ucfirst($a['type']) ?>
              </span>
            </td>
            <td><?= e($a['note'] ?? '-') ?></td>
            <td><?= e($a['user_name']) ?></td>
          </tr>
        <?php endforeach; endif; ?>

      </tbody>
    </table>
  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../../app/views/layout/footer.php'; ?>
