<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

/******************** INCLUDES ********************/
require_once __DIR__ . '/../../../app/core/helpers.php';
require_once __DIR__ . '/../../../app/core/Auth.php';
require_once __DIR__ . '/../../../app/config/database.php';
require_once __DIR__ . '/../../../app/core/Permissions.php';

Auth::requireLogin();

/*
👉 Pour V01 :
- Marketing accessible aux mêmes rôles que clients
- On pourra restreindre plus tard si besoin
*/
Permissions::allow(['admin','director','manager','commercial','finance']);

$title  = "Marketing | Prospects";
$active = 'marketing';

/******************** FILTRES ********************/
$q      = trim($_GET['q'] ?? '');
$status = trim($_GET['status'] ?? '');
$owner  = (int)($_GET['commercial'] ?? 0);

$where  = [];
$params = [];

if ($q !== '') {
    $where[] = "(mp.fullname LIKE ? OR mp.phone LIKE ? OR mp.email LIKE ?)";
    $like = "%$q%";
    $params[] = $like;
    $params[] = $like;
    $params[] = $like;
}

if ($status !== '') {
    $where[] = "mp.status = ?";
    $params[] = $status;
}

if ($owner > 0) {
    $where[] = "mp.commercial_id = ?";
    $params[] = $owner;
}

/******************** REQUÊTE ********************/
$sql = "
SELECT mp.*, u.name AS commercial_name
FROM marketing_prospects mp
LEFT JOIN users u ON u.id = mp.commercial_id
" . ($where ? " WHERE " . implode(" AND ", $where) : "") . "
ORDER BY mp.id DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$prospects = $stmt->fetchAll();

/******************** COMMERCIAUX ********************/
$users = $pdo->query("
    SELECT id, name, role
    FROM users
    WHERE role IN ('commercial','manager','director','admin')
    ORDER BY name ASC
")->fetchAll();

/******************** LAYOUT ********************/
include __DIR__ . '/../../../app/views/layout/header.php';
include __DIR__ . '/../../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<!-- ================= HEADER ================= -->
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Prospects marketing</h3>

  <?php if (Permissions::can(['admin','director','manager','commercial'])): ?>
    <a class="btn btn-success"
       href="<?= e(base_url('/public/marketing/prospects/create.php')) ?>">
      <i class="fas fa-plus"></i> Ajouter un prospect
    </a>
  <?php endif; ?>
</div>

<!-- ================= FILTRES ================= -->
<div class="card mb-3">
  <div class="card-body">
    <form class="row" method="get">

      <div class="col-md-4">
        <input class="form-control"
               name="q"
               value="<?= e($q) ?>"
               placeholder="Recherche (nom, téléphone, email)">
      </div>

      <div class="col-md-3">
        <select class="form-control" name="status">
          <option value="">— Statut —</option>
          <?php foreach (['nouveau','a_contacter','contacte','interesse','non_interesse','converti'] as $s): ?>
            <option value="<?= $s ?>" <?= $status === $s ? 'selected' : '' ?>>
              <?= ucfirst(str_replace('_',' ',$s)) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-3">
        <select class="form-control" name="commercial">
          <option value="0">— Commercial —</option>
          <?php foreach ($users as $u): ?>
            <option value="<?= (int)$u['id'] ?>" <?= $owner === (int)$u['id'] ? 'selected' : '' ?>>
              <?= e($u['name']) ?> (<?= e($u['role']) ?>)
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-2">
        <button class="btn btn-primary w-100">
          <i class="fas fa-search"></i>
        </button>
      </div>

    </form>
  </div>
</div>

<!-- ================= TABLE ================= -->
<div class="card">
  <div class="card-body table-responsive p-0">
    <table class="table table-hover mb-0">
      <thead>
        <tr>
          <th>#</th>
          <th>Prospect</th>
          <th>Téléphone</th>
          <th>Email</th>
          <th>Source</th>
          <th>Statut</th>
          <th>Commercial</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody>

      <?php if (!$prospects): ?>
        <tr>
          <td colspan="8" class="text-center text-muted p-4">
            Aucun prospect marketing.
          </td>
        </tr>
      <?php else: foreach ($prospects as $p): ?>

        <tr>
          <td><?= (int)$p['id'] ?></td>
          <td><?= e($p['fullname']) ?></td>
          <td><?= e($p['phone'] ?? '-') ?></td>
          <td><?= e($p['email'] ?? '-') ?></td>
          <td><?= e($p['source'] ?? '-') ?></td>

         <td>
<?php
$marketingStatuses = ['nouveau','a_contacter','contacte','interesse','non_interesse'];

if (in_array($p['status'], $marketingStatuses, true)): ?>
    <form method="post"
          action="<?= e(base_url('/public/marketing/prospects/update_status.php')) ?>">
        <input type="hidden" name="id" value="<?= (int)$p['id'] ?>">
        <select name="status"
                class="form-control form-control-sm"
                onchange="this.form.submit()">
            <?php foreach ($marketingStatuses as $s): ?>
                <option value="<?= $s ?>" <?= $p['status']===$s?'selected':'' ?>>
                    <?= ucfirst(str_replace('_',' ',$s)) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </form>
<?php else: ?>
    <span class="badge badge-secondary">
        <?= ucfirst(str_replace('_',' ',$p['status'])) ?>
    </span>
<?php endif; ?>
</td>


          <td><?= e($p['commercial_name'] ?? '-') ?></td>

          <td>
            <a class="btn btn-sm btn-secondary"
   href="<?= e(base_url('/public/marketing/prospects/show.php?id='.$p['id'])) ?>">
  <i class="fas fa-eye"></i> Détails
</a>

          </td>
        </tr>

      <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../../app/views/layout/footer.php'; ?>
