<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

/******************** INCLUDES ********************/
require_once __DIR__ . '/../../../app/core/helpers.php';
require_once __DIR__ . '/../../../app/core/Auth.php';
require_once __DIR__ . '/../../../app/config/database.php';
require_once __DIR__ . '/../../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial']);

$title  = "Ajouter un prospect | Marketing";
$active = 'marketing';

/******************** COMMERCIAUX ********************/
$users = $pdo->query("
    SELECT id, name
    FROM users
    WHERE role IN ('commercial','manager','director','admin')
    ORDER BY name ASC
")->fetchAll();

/******************** LAYOUT ********************/
include __DIR__ . '/../../../app/views/layout/header.php';
include __DIR__ . '/../../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Ajouter un prospect marketing</h3>
  <a class="btn btn-secondary"
     href="<?= e(base_url('/public/marketing/prospects/index.php')) ?>">
    <i class="fas fa-arrow-left"></i> Retour
  </a>
</div>

<div class="card">
  <form method="POST"
        action="<?= e(base_url('/public/marketing/prospects/store.php')) ?>">
    <div class="card-body">

      <div class="row">
        <div class="col-md-6 mb-3">
          <label>Nom complet <span class="text-danger">*</span></label>
          <input class="form-control"
                 name="fullname"
                 required>
        </div>

        <div class="col-md-6 mb-3">
          <label>Téléphone</label>
          <input class="form-control"
                 name="phone">
        </div>
      </div>

      <div class="row">
        <div class="col-md-6 mb-3">
          <label>Email</label>
          <input class="form-control"
                 type="email"
                 name="email">
        </div>

        <div class="col-md-6 mb-3">
          <label>Source</label>
          <input class="form-control"
                 name="source"
                 placeholder="Ex : Salon Paris 2025">
        </div>
      </div>

      <div class="mb-3">
        <label>Intérêt / Besoin</label>
        <textarea class="form-control"
                  name="interest"
                  rows="3"
                  placeholder="Ex : Besoin F3 à Alger"></textarea>
      </div>

      <div class="mb-3">
        <label>Commercial assigné <span class="text-danger">*</span></label>
        <select class="form-control"
                name="commercial_id"
                required>
          <option value="">— Choisir un commercial —</option>
          <?php foreach ($users as $u): ?>
            <option value="<?= (int)$u['id'] ?>">
              <?= e($u['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

    </div>

    <div class="card-footer text-right">
      <button class="btn btn-success">
        <i class="fas fa-save"></i> Enregistrer
      </button>
    </div>
  </form>
</div>

</div>
</section>

<?php include __DIR__ . '/../../../app/views/layout/footer.php'; ?>
