<?php
require_once __DIR__ . '/../../../app/core/helpers.php';
require_once __DIR__ . '/../../../app/core/Auth.php';
require_once __DIR__ . '/../../../app/config/database.php';
require_once __DIR__ . '/../../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial']);

$prospect_id = (int)$_POST['prospect_id'];
$type        = $_POST['type'];
$action_date = $_POST['action_date'];
$note        = $_POST['note'] ?? '';

if ($prospect_id <= 0 || !$type || !$action_date) {
    redirect('/public/marketing/prospects/index.php');
}

$stmt = $pdo->prepare("
    INSERT INTO marketing_actions
    (prospect_id, user_id, type, action_date, note)
    VALUES (?, ?, ?, ?, ?)
");

$stmt->execute([
    $prospect_id,
    Auth::user()['id'],
    $type,
    $action_date,
    $note
]);

redirect('/public/marketing/prospects/show.php?id='.$prospect_id);
