<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','finance']);

$status = $_GET['status'] ?? '';
$allowed = ['disponible','reserve','vendu','bloque'];

$where = '';
$params = [];

if ($status && in_array($status, $allowed)) {
    $where = "WHERE l.status = ?";
    $params[] = $status;
}

$sql = "
SELECT l.*, p.name AS project_name, lt.name AS lot_type
FROM lots l
LEFT JOIN projects p ON p.id = l.project_id
LEFT JOIN lot_types lt ON lt.id = l.lot_type_id
$where
ORDER BY l.id DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$lots = $stmt->fetchAll();

$title  = "Situation des lots";
$active = 'lots_status';

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">
   <strong> Situation des lots</strong>
    <?php if ($status): ?>
      — <?= ucfirst($status) ?>
    <?php endif; ?>
  </h3>
</div>

<div class="card">
  <div class="card-body table-responsive p-0">
    <table class="table table-hover mb-0">
      <thead>
        <tr>
          <th>#</th>
          <th>Projet</th>
          <th>N du lot</th>
          <th>Type</th>
          <th>Surface</th>
          <th>Prix</th>
          <th>État</th>
        </tr>
      </thead>
      <tbody>

      <?php if (!$lots): ?>
        <tr>
          <td colspan="7" class="text-center text-muted p-4">
            Aucun lot trouvé
          </td>
        </tr>
      <?php else: foreach ($lots as $l): ?>
        <tr>
          <td><?= (int)$l['id'] ?></td>
          <td><strong><?= e($l['project_name'] ?? '-') ?><strong></td>
          <td><?= e($l['reference']) ?></td>
          <td><?= e($l['lot_type'] ?? '-') ?></td>
          <td><?= number_format((float)$l['surface'], 2) ?> m²</td>
          <td><?= number_format((float)$l['price'], 0, ' ', ' ') ?> DA</td>
          <td>
            <span class="badge badge-<?=
              match($l['status']) {
                'disponible' => 'success',
                'reserve'    => 'warning',
                'vendu'      => 'primary',
                'bloque'     => 'danger',
                default      => 'secondary'
              }
            ?>">
              <?= ucfirst($l['status']) ?>
            </span>
          </td>
        </tr>
      <?php endforeach; endif; ?>

      </tbody>
    </table>
  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
